/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.impl.BaseKSActivity;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/PollUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class PollUIActivity
extends BaseKSActivity {
    private String[] getVotes(String infoVote) {
        Object[] tab = infoVote.split("\\|");
        tab = (String[])ArrayUtils.removeElement((Object[])tab, (Object)tab[tab.length - 1]);
        for (int i = 0; i < tab.length; ++i) {
            String option = ((String)tab[i]).split(":")[0];
            String percent = ((String)tab[i]).split(":")[1];
            String nbVotes = ((String)tab[i]).split(":")[2];
            int number = Integer.parseInt(nbVotes);
            nbVotes = number <= 1 ? WebUIUtils.getLabel(null, (String)"PollUIActivity.label.vote").replace("{0}", String.valueOf(number)) : WebUIUtils.getLabel(null, (String)"PollUIActivity.label.votes").replace("{0}", String.valueOf(number));
            StringBuilder sb = new StringBuilder();
            sb.append(option).append(":").append(percent).append(":").append(nbVotes);
            tab[i] = sb.toString();
        }
        return tab;
    }

    private String getNumberOfVotes(String infoVote) {
        String[] tab = infoVote.split("\\|");
        int number = Integer.parseInt(tab[tab.length - 1]);
        if (number <= 1) {
            return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.vote").replace("{0}", String.valueOf(number));
        }
        return WebUIUtils.getLabel(null, (String)"PollUIActivity.label.votes").replace("{0}", String.valueOf(number));
    }

    private String getLink() {
        String spaceLink = this.getSpaceHomeURL(this.getSpaceGroupId());
        if (spaceLink == null) {
            return this.getActivityParamValue("PollLink");
        }
        String topicId = this.getActivityParamValue("Id");
        String topicLink = String.format("%s/forum/topic/%s", spaceLink, topicId);
        return topicLink;
    }

    private String getSpaceGroupId() {
        return this.getActivityParamValue("SpaceGroupId");
    }

    public String getSpaceHomeURL(String spaceGroupId) {
        if ("".equals(spaceGroupId)) {
            return null;
        }
        String permanentSpaceName = spaceGroupId.split("/")[2];
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByGroupId(spaceGroupId);
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }
}

