/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.Arrays;
import java.util.HashSet;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class ForumDataInitialize
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(ForumDataInitialize.class);
    private final InitParams params;

    public ForumDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        block8: {
            String portletName = "";
            if (this.params.getValueParam("portletName") != null) {
                portletName = this.params.getValueParam("portletName").getValue();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initparam is not configured for portletName property");
            }
            if (!portletName.equals(event.getSource())) {
                return;
            }
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            ForumService fServie = (ForumService)exoContainer.getComponentInstanceOfType(ForumService.class);
            Space space = event.getSpace();
            String parentGrId = "";
            try {
                String forumId;
                OrganizationService service = (OrganizationService)exoContainer.getComponentInstanceOfType(OrganizationService.class);
                Group group = service.getGroupHandler().findGroupById(space.getGroupId());
                parentGrId = group.getParentId();
                String categorySpId = Utils.CATEGORY + parentGrId.replaceAll(CommonUtils.SLASH, CommonUtils.EMPTY_STR);
                Category category = fServie.getCategory(categorySpId);
                if (category == null) {
                    category = new Category(categorySpId);
                    category.setCategoryName("/spaces".replace(CommonUtils.SLASH, CommonUtils.EMPTY_STR));
                    category.setOwner(space.getManagers()[0]);
                    category.setCategoryOrder(100L);
                    category.setUserPrivate(new String[]{""});
                    category.setDescription("All forums from spaces");
                    fServie.saveCategory(category, true);
                }
                if (fServie.getForum(categorySpId, forumId = Utils.FORUM_SPACE_ID_PREFIX + group.getGroupName()) == null) {
                    HashSet<String> prs = new HashSet<String>(Arrays.asList(category.getUserPrivate()));
                    prs.add(space.getGroupId());
                    category.setUserPrivate(prs.toArray(new String[prs.size()]));
                    fServie.saveCategory(category, false);
                    String[] roles = new String[]{space.getGroupId()};
                    String[] moderators = new String[]{"manager" + CommonUtils.COLON + space.getGroupId()};
                    Forum forum = new Forum();
                    forum.setOwner(space.getManagers()[0]);
                    forum.setId(forumId);
                    forum.setForumName(space.getDisplayName());
                    forum.setDescription(space.getDescription());
                    forum.setModerators(moderators);
                    forum.setCreateTopicRole(roles);
                    forum.setPoster(roles);
                    forum.setViewer(roles);
                    fServie.saveForum(categorySpId, forum, true);
                }
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)("Failed to add forum space. " + e.getMessage()));
            }
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
    }

    public void spaceAccessEdited(SpaceLifeCycleEvent event) {
    }
}

