/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.forum.common.TransformHTML;
import org.exoplatform.forum.common.webui.WebUIUtils;
import org.exoplatform.forum.ext.activity.ForumActivityBuilder;
import org.exoplatform.forum.ext.activity.ForumActivityContext;
import org.exoplatform.forum.ext.activity.ForumActivityUtils;
import org.exoplatform.forum.ext.impl.BaseKSActivity;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.DataStorage;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.MessageBuilder;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/forum/social-integration/plugin/space/ForumUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class})})
public class ForumUIActivity
extends BaseKSActivity {
    private static final Log LOG = ExoLogger.getLogger(ForumUIActivity.class);
    private static final String SPACES_GROUP = "/spaces".substring(1);
    private static final String FORUM_PAGE_NAGVIGATION = "forum";
    private static final String FORUM_PORTLET_NAME = "ForumPortlet";
    private static final String SPACE_GROUP_ID = "SpaceGroupId";

    protected String getReplyLink() {
        String viewLink = this.buildLink();
        StringBuffer sb = new StringBuffer(viewLink);
        if (sb.lastIndexOf("/") == -1 || sb.lastIndexOf("/") != sb.length() - 1) {
            sb.append("/");
        }
        sb.append("lastpost/false");
        return sb.toString();
    }

    private String buildLink() {
        String topicId = this.getActivityParamValue("TopicId");
        String categoryId = this.getActivityParamValue("CateId");
        String forumId = this.getActivityParamValue("ForumId");
        try {
            ForumService fs = ForumActivityUtils.getForumService();
            Category cate = fs.getCategory(categoryId);
            String link = "";
            if (cate.getId().indexOf(SPACES_GROUP) > 0) {
                Forum forum = fs.getForum(categoryId, forumId);
                String spaceGroupId = ForumActivityUtils.getSpaceGroupId(forum.getId());
                link = this.buildTopicLink(spaceGroupId, topicId);
            } else {
                UserNavigation userNav;
                PortalRequestContext prc = Util.getPortalRequestContext();
                UserPortal userPortal = prc.getUserPortal();
                UserNode userNode = userPortal.getNode(userNav = userPortal.getNavigation(prc.getSiteKey()), Scope.ALL, null, null);
                UserNode forumNode = userNode.getChild(FORUM_PAGE_NAGVIGATION);
                if (forumNode != null) {
                    String forumURI = this.getNodeURL(forumNode);
                    link = String.format("%s/topic/%s", forumURI, topicId);
                }
            }
            return link;
        }
        catch (Exception ex) {
            return "";
        }
    }

    private String getLink(String tagLink, String nameLink) {
        String link = this.buildLink();
        return String.format(tagLink, link, nameLink);
    }

    private String getNodeURL(UserNode node) {
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        return nodeURL.setNode(node).toString();
    }

    public String buildTopicLink(String spaceGroupId, String topicId) throws Exception {
        NavigationContext nav;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(SiteKey.group((String)spaceGroupId)), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            NodeContext nodeCtx = (NodeContext)parentNodeCtx.get(0);
            Collection children = nodeCtx.getNodes();
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext() && !FORUM_PAGE_NAGVIGATION.equals((child = (NodeContext)it.next()).getName()) && child.getName().indexOf(FORUM_PORTLET_NAME) < 0) {
            }
            String spaceLink = ForumUIActivity.getSpaceHomeURL(spaceGroupId);
            String topicLink = String.format("%s/%s/topic/%s", spaceLink, child.getName(), topicId);
            return topicLink;
        }
        return "";
    }

    public static String getSpaceHomeURL(String spaceGroupId) {
        String permanentSpaceName = spaceGroupId.split("/")[2];
        Space space = ForumActivityUtils.getSpaceService().getSpaceByGroupId(spaceGroupId);
        NodeURL nodeURL = (NodeURL)RequestContext.getCurrentInstance().createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.GROUP, "/spaces/" + permanentSpaceName, space.getPrettyName());
        return nodeURL.setResource(resource).toString();
    }

    public String getViewLink() {
        return this.buildLink();
    }

    public String getLastReplyLink() {
        String viewLink = this.buildLink();
        return Utils.isEmpty((String)viewLink) ? "" : viewLink.concat("/lastpost");
    }

    protected String getViewPostLink(ExoSocialActivity activity) {
        String topicView = this.buildLink();
        Map templateParams = activity.getTemplateParams();
        if (templateParams != null && templateParams.containsKey("PostId")) {
            return topicView.concat("/").concat((String)templateParams.get("PostId"));
        }
        return "";
    }

    private String getActivityContentTitle(WebuiBindingContext _ctx, String herf) throws Exception {
        String title = this.getActivity().getTitle();
        String linkTag = "";
        try {
            linkTag = this.getLink(herf, title);
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to get activity content and title ", (Throwable)e);
        }
        return linkTag;
    }

    public String getNumberOfReplies() {
        String got = this.getActivityParamValue("NumberOfReplies");
        int nbReplies = Integer.parseInt(Utils.isEmpty((String)got) ? "0" : got);
        switch (nbReplies) {
            case 0: {
                return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.noReply");
            }
            case 1: {
                return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.oneReply").replace("{0}", got);
            }
        }
        return WebUIUtils.getLabel(null, (String)"ForumUIActivity.label.replies").replace("{0}", got);
    }

    public double getRate() {
        String got = this.getActivityParamValue("TopicVoteRate");
        try {
            return Double.parseDouble(got);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public boolean isTopicActivity() {
        return !Utils.isEmpty((String)this.getActivityParamValue("TopicId"));
    }

    public Post createPost(String message, WebuiRequestContext requestContext) {
        try {
            DataStorage dataStorage = (DataStorage)PortalContainer.getInstance().getComponentInstanceOfType(DataStorage.class);
            String topicId = this.getActivityParamValue("TopicId");
            String categoryId = this.getActivityParamValue("CateId");
            String forumId = this.getActivityParamValue("ForumId");
            Topic topic = dataStorage.getTopic(categoryId, forumId, topicId, "");
            Post post = new Post();
            post.setOwner(requestContext.getRemoteUser());
            post.setIcon("IconsView");
            post.setName("Re: " + topic.getTopicName());
            post.setLink(topic.getLink());
            PortalRequestContext context = Util.getPortalRequestContext();
            String remoteAddr = context.getRequest().getRemoteAddr();
            post.setRemoteAddr(remoteAddr);
            post.setModifiedBy(requestContext.getRemoteUser());
            post.setMessage(message);
            dataStorage.savePost(categoryId, forumId, topicId, post, true, new MessageBuilder());
            ExoSocialActivity activity = this.getActivity();
            activity = ForumActivityBuilder.updateNumberOfReplies(activity, false);
            activity.setTitle(null);
            activity.setBody(null);
            ForumActivityUtils.updateActivities(activity);
            return post;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveComment(Post post) {
        ForumActivityContext ctx = ForumActivityContext.makeContextForAddPost(post);
        ExoSocialActivity comment = ForumActivityBuilder.createActivityComment(ctx.getPost(), ctx);
        comment.setUserId(org.exoplatform.social.webui.Utils.getViewerIdentity().getId());
        comment.setTitle(post.getMessage());
        comment.setBody(post.getMessage());
        ForumActivityUtils.getActivityManager().saveComment(this.getActivity(), comment);
        ForumActivityUtils.takeCommentBack(post, comment);
        this.refresh();
    }

    protected ExoSocialActivity getI18N(ExoSocialActivity activity) {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        I18NActivityProcessor i18NActivityProcessor = (I18NActivityProcessor)this.getApplicationComponent(I18NActivityProcessor.class);
        if (activity.getTitleId() != null) {
            Locale userLocale = requestContext.getLocale();
            activity = i18NActivityProcessor.processKeys(activity, userLocale);
            String title = activity.getTitle().replaceAll("<br/>", "BR_").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            activity.setTitle(title.replaceAll("BR_", "<br/>"));
        }
        return activity;
    }

    private String getSpaceGroupId() {
        return this.getActivityParamValue(SPACE_GROUP_ID);
    }

    public static class PostCommentActionListener
    extends BaseUIActivity.PostCommentActionListener {
        public void execute(Event<BaseUIActivity> event) throws Exception {
            ForumUIActivity uiActivity = (ForumUIActivity)((Object)event.getSource());
            if (!uiActivity.isTopicActivity()) {
                super.execute(event);
                return;
            }
            WebuiRequestContext requestContext = event.getRequestContext();
            UIFormTextAreaInput uiFormComment = (UIFormTextAreaInput)uiActivity.getChild(UIFormTextAreaInput.class);
            String message = (String)uiFormComment.getValue();
            uiFormComment.reset();
            Post post = uiActivity.createPost(TransformHTML.enCodeHTMLContent((String)message), requestContext);
            post.setMessage(message);
            uiActivity.saveComment(post);
            uiActivity.setCommentFormFocused(true);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiActivity);
            uiActivity.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

