/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.ext.common;

import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.forum.common.user.CommonContact;
import org.exoplatform.forum.common.user.ContactProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;

public class SocialContactProvider
implements ContactProvider {
    private static final Log LOG = ExoLogger.getLogger(SocialContactProvider.class);

    public CommonContact getCommonContact(String userId) {
        Identity userIdentity;
        CommonContact contact = null;
        IdentityManager identityM = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        if (identityM != null && (userIdentity = identityM.getOrCreateIdentity("organization", userId, true)) != null) {
            List profiles;
            contact = new CommonContact();
            Profile profile = userIdentity.getProfile();
            contact.setEmailAddress(profile.getEmail());
            contact.setFullName(profile.getFullName());
            contact.setAvatarUrl(profile.getAvatarUrl());
            contact.setJob(profile.getPosition());
            if (profile.contains("firstName")) {
                contact.setFirstName(profile.getProperty("firstName").toString());
            }
            if (profile.contains("lastName")) {
                contact.setLastName(profile.getProperty("lastName").toString());
            }
            if (profile.contains("gender")) {
                contact.setGender(profile.getProperty("gender").toString());
            }
            if (profile.contains("phones") && (profiles = (List)profile.getProperty("phones")) != null) {
                for (Map mapInfo : profiles) {
                    contact.setWorkPhone(this.getValueByKey(mapInfo, "Work", contact.getWorkPhone()));
                    contact.setHomePhone(this.getValueByKey(mapInfo, "Home", contact.getHomePhone()));
                }
            }
            if (profile.contains("urls")) {
                profiles = (List)profile.getProperty("urls");
                if (profiles != null) {
                    for (Map mapInfo : profiles) {
                        contact.setWebSite(this.getValueByKey(mapInfo, "url", contact.getWebSite()));
                    }
                }
            } else {
                contact.setWebSite(LinkProvider.getProfileUri((String)userId));
            }
        }
        if (contact == null) {
            LOG.warn((Object)String.format("Could not retrieve forum user profile for %s by SocialContactProvider.", userId));
            return new CommonContact();
        }
        return contact;
    }

    private String getValueByKey(Map<String, String> mapInfo, String key, String value) {
        if (mapInfo != null && key.equals(mapInfo.get("key"))) {
            String str = mapInfo.get("value");
            if (value.length() > 0) {
                str = new StringBuffer(value).append(", ").append(str).toString();
            }
            return str;
        }
        return value;
    }
}

