/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.listener;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.portal.mop.navigation.NavigationStore;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOService;

public class SeoESListenerImpl
extends Listener<SEOService, PageMetadataModel> {
    private IndexingService indexingService;
    private NavigationStore navigationStore;

    public SeoESListenerImpl(IndexingService indexingService, NavigationStore navigationStore) {
        this.indexingService = indexingService;
        this.navigationStore = navigationStore;
    }

    public void onEvent(Event<SEOService, PageMetadataModel> event) throws Exception {
        PageMetadataModel seo = (PageMetadataModel)event.getData();
        this.updateIndex(seo);
    }

    private void updateIndex(PageMetadataModel seo) {
        for (String id : this.search(seo)) {
            this.indexingService.reindex("navigation", id);
        }
    }

    public List<String> search(PageMetadataModel seo) {
        String pageRef = seo.getPageReference();
        NodeData[] nodes = this.navigationStore.loadNodes(pageRef);
        ArrayList<String> ids = new ArrayList<String>();
        for (NodeData node : nodes) {
            ids.add(node.getId());
        }
        return ids;
    }
}

