/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.jdbc.listener;

import org.exoplatform.commons.search.index.IndexingService;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NavigationNodeESListenerImpl
extends Listener<NavigationService, NodeContext> {
    private static final Log LOG = ExoLogger.getExoLogger(NavigationNodeESListenerImpl.class);
    private IndexingService indexingService;
    private NavigationService navigationService;

    public NavigationNodeESListenerImpl(IndexingService indexingService, NavigationService navigationService) {
        this.indexingService = indexingService;
        this.navigationService = navigationService;
    }

    public void onEvent(Event<NavigationService, NodeContext> event) throws Exception {
        String eventName = event.getEventName();
        NodeContext node = (NodeContext)event.getData();
        LOG.debug("Notifying indexing service for navigation node={}", new Object[]{node.getId()});
        if ("org.exoplatform.portal.mop.navigation.node_add".equals(eventName) || "org.exoplatform.portal.mop.navigation.node_create".equals(eventName)) {
            this.indexingService.index("navigation", node.getId());
        } else if ("org.exoplatform.portal.mop.navigation.node_destroy".equals(eventName) || "org.exoplatform.portal.mop.navigation.node_remove".equals(eventName)) {
            this.indexingService.unindex("navigation", node.getId());
        } else if ("org.exoplatform.portal.mop.navigation.node_move".equals(eventName) || "org.exoplatform.portal.mop.navigation.node_rename".equals(eventName) || "org.exoplatform.portal.mop.navigation.node_update".equals(eventName)) {
            this.indexingService.reindex("navigation", node.getId());
        }
    }
}

