/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.faq.service.Answer;
import org.exoplatform.faq.service.Comment;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Question;
import org.exoplatform.faq.service.impl.AnswerEventListener;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnswersSpaceActivityPublisher
extends AnswerEventListener {
    public static final String SPACE_APP_ID = "ks-answer:spaces";
    public static final String QUESTION_ID_KEY = "QuestionId";
    public static final String ANSWER_ID_KEY = "AnswerId";
    public static final String COMMENT_ID_KEY = "CommentId";
    public static final String ACTIVITY_TYPE_KEY = "ActivityType";
    public static final String AUTHOR_KEY = "Author";
    public static final String LINK_KEY = "Link";
    public static final String QUESTION_NAME_KEY = "Name";
    public static final String LANGUAGE_KEY = "Language";
    public static final String ANSWER = "Answer";
    public static final String QUESTION = "Question";
    public static final String COMMENT = "Comment";
    public static final String ANSWER_ADD = "AnswerAdd";
    public static final String QUESTION_ADD = "QuestionAdd";
    public static final String COMMENT_ADD = "CommentAdd";
    public static final String ANSWER_UPDATE = "AnswerUpdate";
    public static final String QUESTION_UPDATE = "QuestionUpdate";
    public static final String COMMENT_UPDATE = "CommentUpdate";
    private static Log LOG = ExoLogger.getExoLogger(AnswerEventListener.class);

    private boolean isCategoryPublic(String categoryId, List<String> categories) throws Exception {
        if (categoryId != null) {
            FAQService faqS = (FAQService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(FAQService.class);
            String[] users = (String[])faqS.readCategoryProperty(categoryId, "exo:userPrivate", String[].class);
            int parentIndex = categories.indexOf(categoryId) - 1;
            return Utils.isEmpty((String[])users) && (parentIndex < 0 || this.isCategoryPublic(categories.get(parentIndex), categories));
        }
        return false;
    }

    private boolean isQuestionPublic(Question question) {
        return question != null && question.isActivated() && question.isApproved();
    }

    private boolean isAnswerPublic(Answer answer) {
        return answer != null && answer.getApprovedAnswers() && answer.getActivateAnswers();
    }

    private Identity getSpaceIdentity(String categoryId) {
        if (categoryId.indexOf(org.exoplatform.faq.service.Utils.CATE_SPACE_ID_PREFIX) < 0) {
            return null;
        }
        String prettyname = categoryId.split(org.exoplatform.faq.service.Utils.CATE_SPACE_ID_PREFIX)[1];
        IdentityManager identityM = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByPrettyName(prettyname);
        if (space != null) {
            return identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
        }
        return null;
    }

    private ExoSocialActivity newActivity(Identity author, String title, String body, Map<String, String> templateParams) {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setUserId(author.getId());
        activity.setTitle(title);
        activity.setBody(body);
        activity.setType(SPACE_APP_ID);
        activity.setTemplateParams(templateParams);
        return activity;
    }

    private Map<String, String> updateTemplateParams(Map<String, String> templateParams, String activityType, String questionId, String questionName, String language, String link) {
        templateParams.put(QUESTION_ID_KEY, questionId);
        templateParams.put(ACTIVITY_TYPE_KEY, activityType);
        templateParams.put(QUESTION_NAME_KEY, questionName);
        templateParams.put(LINK_KEY, link);
        templateParams.put(LANGUAGE_KEY, language);
        return templateParams;
    }

    public void saveAnswer(String questionId, Answer answer, boolean isNew) {
        try {
            Question q;
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
            ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
            FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
            if (this.isAnswerPublic(answer) && this.isQuestionPublic(q = faqS.getQuestionById(questionId))) {
                String activityType;
                Identity userIdentity = identityM.getOrCreateIdentity("organization", answer.getResponseBy(), false);
                Identity streamOwner = null;
                Identity author = userIdentity;
                String catId = q.getCategoryId();
                Identity spaceIdentity = this.getSpaceIdentity(catId);
                if (spaceIdentity != null) {
                    streamOwner = spaceIdentity;
                }
                List categoryIds = faqS.getCategoryPath(catId);
                Collections.reverse(categoryIds);
                if (streamOwner == null && this.isCategoryPublic(catId, categoryIds)) {
                    streamOwner = userIdentity;
                }
                String string = activityType = isNew ? ANSWER_ADD : ANSWER_UPDATE;
                if (streamOwner != null) {
                    Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), activityType, questionId, q.getQuestion(), q.getLanguage(), q.getLink());
                    templateParams.put(ANSWER_ID_KEY, answer.getId());
                    templateParams.put(AUTHOR_KEY, answer.getResponseBy());
                    activityM.saveActivityNoReturn(streamOwner, this.newActivity(author, "@" + answer.getResponseBy(), answer.getResponses(), templateParams));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when post answer ", (Throwable)e);
        }
    }

    public void saveComment(String questionId, Comment comment, boolean isNew) {
    }

    public void saveQuestion(Question question, boolean isNew) {
        try {
            if (this.isQuestionPublic(question)) {
                ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
                IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
                ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
                FAQService faqS = (FAQService)exoContainer.getComponentInstanceOfType(FAQService.class);
                Identity userIdentity = identityM.getOrCreateIdentity("organization", question.getAuthor(), false);
                Identity streamOwner = null;
                Identity author = userIdentity;
                String catId = (String)faqS.readQuestionProperty(question.getId(), "exo:categoryId", String.class);
                Identity spaceIdentity = this.getSpaceIdentity(catId);
                if (spaceIdentity != null) {
                    streamOwner = spaceIdentity;
                }
                List categoryIds = faqS.getCategoryPath(catId);
                Collections.reverse(categoryIds);
                if (streamOwner == null && this.isCategoryPublic(catId, categoryIds)) {
                    streamOwner = userIdentity;
                }
                if (streamOwner != null) {
                    Map<String, String> templateParams = this.updateTemplateParams(new HashMap<String, String>(), isNew ? QUESTION_ADD : QUESTION_UPDATE, question.getId(), question.getQuestion(), question.getLanguage(), question.getLink());
                    activityM.saveActivityNoReturn(streamOwner, this.newActivity(author, "@" + question.getAuthor(), question.getDetail(), templateParams));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when add new question ", (Throwable)e);
        }
    }

    public void saveAnswer(String questionId, Answer[] answers, boolean isNew) {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            if (answers != null) {
                for (Answer a : answers) {
                    this.saveAnswer(questionId, a, isNew);
                }
            }
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when post answer " + e.getMessage()));
        }
    }
}

