/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class AnswerDataInitialize
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getLogger(AnswerDataInitialize.class);
    private final InitParams params;

    public AnswerDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        try {
            portletName = this.params.getValueParam("portletName").getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        Space space = event.getSpace();
        FAQService fServie = (FAQService)PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
        try {
            Category parent = fServie.getCategoryById("categories");
            if (parent != null) {
                Category cat = new Category();
                cat.setId(Utils.CATE_SPACE_ID_PREFIX + space.getPrettyName());
                cat.setName(space.getDisplayName());
                cat.setUserPrivate(new String[]{space.getGroupId()});
                cat.setDescription(space.getDescription());
                cat.setIndex(1L);
                cat.setModerators(new String[]{"manager:" + space.getGroupId()});
                if (fServie.getCategoryById(cat.getId()) == null) {
                    fServie.saveCategory("categories", cat, true);
                }
            } else {
                log.error((Object)"\n\n Root category null please check to create one !");
            }
        }
        catch (Exception e) {
            log.error((Object)("\n\n Initialize category false " + e.getMessage()));
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

