/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.search.indexing.listeners;

import java.util.HashMap;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.impl.CalendarEventListener;
import org.exoplatform.commons.api.indexing.IndexingService;
import org.exoplatform.commons.api.indexing.data.SearchEntry;
import org.exoplatform.commons.api.indexing.data.SearchEntryId;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class UnifiedSearchCalendarListener
extends CalendarEventListener {
    private static Log log = ExoLogger.getLogger(UnifiedSearchCalendarListener.class);
    private final IndexingService indexingService;

    public UnifiedSearchCalendarListener(IndexingService indexingService) {
        this.indexingService = indexingService;
    }

    public void savePublicEvent(CalendarEvent event, String calendarId) {
        if (this.indexingService != null) {
            HashMap<String, CalendarEvent> content = new HashMap<String, CalendarEvent>();
            content.put("event", event);
            SearchEntry searchEntry = new SearchEntry("calendar", event.getEventType().toLowerCase(), event.getId(), content);
            this.indexingService.add(searchEntry);
        }
    }

    public void updatePublicEvent(CalendarEvent event, String calendarId) {
        if (this.indexingService != null) {
            HashMap<String, CalendarEvent> content = new HashMap<String, CalendarEvent>();
            content.put("event", event);
            SearchEntryId searchEntryId = new SearchEntryId("calendar", event.getEventType().toLowerCase(), event.getId());
            this.indexingService.update(searchEntryId, content);
        }
    }

    public void deletePublicEvent(CalendarEvent event, String calendarId) {
        if (this.indexingService != null) {
            SearchEntryId searchEntryId = new SearchEntryId("calendar", event.getEventType().toLowerCase(), event.getId());
            this.indexingService.delete(searchEntryId);
        }
    }

    public void updatePublicEvent(CalendarEvent oldEvent, CalendarEvent event, String calendarId) {
        if (this.indexingService != null) {
            HashMap<String, CalendarEvent> content = new HashMap<String, CalendarEvent>();
            content.put("event", event);
            SearchEntryId searchEntryId = new SearchEntryId("calendar", event.getEventType().toLowerCase(), event.getId());
            this.indexingService.update(searchEntryId, content);
        }
    }
}

