/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.plugin.doc.UIDocActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.commons.UIDocumentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivitySelector.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={SelectedFileActionListener.class})})
public class UIDocActivitySelector
extends UIContainer
implements UIPopupComponent {
    protected static final String UIDOCUMENTSELECTOR = "UIDocumentSelector";
    protected static final String CANCEL = "Cancel";
    public static final String SELECTEDFILE = "SelectedFile";
    private static final Log LOG = ExoLogger.getLogger(UIDocActivitySelector.class);

    public UIDocActivitySelector() {
        try {
            UIDocumentSelector documentSelector = (UIDocumentSelector)this.addChild(UIDocumentSelector.class, null, UIDOCUMENTSELECTOR);
        }
        catch (Exception e) {
            LOG.error((Object)"An exception happens when init UIDocActivitySelector", (Throwable)e);
        }
    }

    public void activate() {
    }

    public void deActivate() {
        UIPopupWindow popup = (UIPopupWindow)this.getParent();
        popup.setUIComponent(null);
        popup.setShow(false);
        popup.setRendered(false);
    }

    public static class SelectedFileActionListener
    extends EventListener<UIDocActivitySelector> {
        public void execute(Event<UIDocActivitySelector> event) throws Exception {
            UIDocActivitySelector uiDocActivitySelector = (UIDocActivitySelector)((Object)event.getSource());
            UIContainer optionContainer = (UIContainer)uiDocActivitySelector.getAncestorOfType(UIContainer.class);
            String rawPath = ((UIDocumentSelector)uiDocActivitySelector.getChild(UIDocumentSelector.class)).getSeletedFile();
            if (rawPath == null || rawPath.trim().length() <= 0) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIDocActivitySelector.msg.not-a-file", null, 1));
                ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).setFullRender(true);
                return;
            }
            UIComposer uiComposer = (UIComposer)optionContainer.getParent().findFirstComponentOfType(UIComposer.class);
            UIDocActivityComposer uiDocActivityComposer = (UIDocActivityComposer)uiComposer.findFirstComponentOfType(UIDocActivityComposer.class);
            uiDocActivityComposer.doSelect(null, rawPath);
            uiDocActivitySelector.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)optionContainer);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDocActivityComposer);
        }
    }

    public static class CancelActionListener
    extends EventListener<UIDocActivitySelector> {
        public void execute(Event<UIDocActivitySelector> event) throws Exception {
            UIDocActivitySelector uiDocActivitySelector = (UIDocActivitySelector)((Object)event.getSource());
            UIContainer optionContainer = (UIContainer)uiDocActivitySelector.getAncestorOfType(UIContainer.class);
            uiDocActivitySelector.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)optionContainer);
        }
    }
}

