/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.doc;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import org.apache.commons.io.FileUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.social.plugin.doc.UIDocViewer;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/plugin/doc/UIDocActivity.gtmpl", events={@EventConfig(listeners={DownloadDocumentActionListener.class}), @EventConfig(listeners={ViewDocumentActionListener.class}), @EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class UIDocActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(UIDocActivity.class);
    private static final String IMAGE_PREFIX = "image/";
    private static final String DOCUMENT_POSTFIX = "/pdf";
    public static final String ACTIVITY_TYPE = "DOC_ACTIVITY";
    public static final String DOCLINK = "DOCLINK";
    public static final String MESSAGE = "MESSAGE";
    public static final String REPOSITORY = "REPOSITORY";
    public static final String WORKSPACE = "WORKSPACE";
    public static final String DOCNAME = "DOCNAME";
    public static final String DOCPATH = "DOCPATH";
    public String docLink;
    public String message;
    public String docName;
    public String docPath;
    public String repository;
    public String workspace;

    protected boolean isPreviewable() {
        return this.getMimeType().endsWith(DOCUMENT_POSTFIX);
    }

    protected boolean isImageFile() {
        return this.getMimeType().startsWith(IMAGE_PREFIX);
    }

    protected String getDocThumbnail() {
        String portalContainerName = PortalContainer.getCurrentPortalContainerName();
        String restContextName = PortalContainer.getRestContextName((String)portalContainerName);
        return new StringBuffer().append("/").append(portalContainerName).append("/").append(restContextName).append("/thumbnailImage/big").append("/").append("repository").append("/").append("collaboration").append(this.docPath).toString();
    }

    protected String getSize() {
        double size = 0.0;
        Node docNode = this.getDocNode();
        try {
            if (docNode.hasNode("jcr:content")) {
                Node contentNode = docNode.getNode("jcr:content");
                if (contentNode.hasProperty("jcr:data")) {
                    size = contentNode.getProperty("jcr:data").getLength();
                }
                return FileUtils.byteCountToDisplaySize((long)((long)size));
            }
        }
        catch (PathNotFoundException e) {
            return "";
        }
        catch (ValueFormatException e) {
            return "";
        }
        catch (RepositoryException e) {
            return "";
        }
        return "";
    }

    protected int getVersion() {
        try {
            VersionNode rootVersion_ = new VersionNode(NodeLocation.getNodeByLocation((NodeLocation)new NodeLocation(this.repository, this.workspace, this.docPath)).getVersionHistory().getRootVersion(), this.getDocNode().getSession());
            if (rootVersion_ != null) {
                return rootVersion_.getChildren().size();
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            return 0;
        }
        catch (RepositoryException e) {
            return 0;
        }
        return 0;
    }

    private Node getDocNode() {
        NodeLocation nodeLocation = new NodeLocation(this.repository, this.workspace, this.docPath);
        return NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
    }

    public String getSummary() {
        String desc;
        block6: {
            desc = "";
            Node node = this.getDocNode();
            try {
                if (node != null) {
                    Node content;
                    if (node.hasProperty("exo:summary")) {
                        desc = node.getProperty("exo:summary").getValue().getString();
                    } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:description") && content.getProperty("dc:description").getValues().length > 0) {
                        desc = content.getProperty("dc:description").getValues()[0].getString();
                    }
                }
            }
            catch (RepositoryException re) {
                if (!LOG.isWarnEnabled()) break block6;
                LOG.warn((Object)"RepositoryException: ", (Throwable)re);
            }
        }
        return desc;
    }

    public String getTitle() throws Exception {
        return Utils.getTitle((Node)this.getDocNode());
    }

    private String getMimeType() {
        String mimeType = "";
        try {
            mimeType = this.getDocNode().getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (ValueFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        catch (PathNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            return "";
        }
        return mimeType;
    }

    public static class DownloadDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity uiComp = (UIDocActivity)((Object)event.getSource());
            String downloadLink = null;
            if (this.getRealNode(uiComp.getDocNode()).getPrimaryNodeType().getName().equals("nt:file")) {
                downloadLink = Utils.getDownloadRestServiceLink((Node)uiComp.getDocNode());
            }
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
        }

        private Node getRealNode(Node node) throws Exception {
            if (node.isNodeType("nt:frozenNode")) {
                String uuid = node.getProperty("jcr:frozenUuid").getString();
                return node.getSession().getNodeByUUID(uuid);
            }
            return node;
        }
    }

    public static class ViewDocumentActionListener
    extends EventListener<UIDocActivity> {
        public void execute(Event<UIDocActivity> event) throws Exception {
            UIDocActivity docActivity = (UIDocActivity)((Object)event.getSource());
            UIActivitiesContainer activitiesContainer = (UIActivitiesContainer)docActivity.getParent();
            UIPopupWindow popupWindow = activitiesContainer.getPopupWindow();
            if (docActivity.getChild(UIDocViewer.class) != null) {
                docActivity.removeChild(UIDocViewer.class);
            }
            UIDocViewer docViewer = (UIDocViewer)popupWindow.createUIComponent(UIDocViewer.class, null, "DocViewer");
            docViewer.docPath = docActivity.docPath;
            docViewer.repository = docActivity.repository;
            docViewer.workspace = docActivity.workspace;
            popupWindow.setUIComponent((UIComponent)docViewer);
            popupWindow.setWindowSize(800, 600);
            popupWindow.setShow(true);
            popupWindow.setResizable(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupWindow);
        }
    }
}

