/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.ckeditor.listener;

import java.time.YearMonth;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.ckeditor.HTMLUploadImageProcessor;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ActivityImageLinkUpdateListener
extends ActivityListenerPlugin {
    private static final String PERSONAL_DOCUMENTS_DRIVE_NAME_PARAM = "personal.drive.name";
    private static final String PERSONAL_DOCUMENTS_DRIVE_NAME = "Personal Documents";
    private static final String SPACE_DOCUMENTS_FOLDER = "Activity Stream Documents/Pictures";
    private static final String PERSONAL_DOCUMENTS_FOLDER = "Public/Activity Stream Documents/Pictures";
    private static final Log LOG = ExoLogger.getLogger(ActivityImageLinkUpdateListener.class);
    private final ActivityManager activityManager;
    private final IdentityManager identityManager;
    private final ManageDriveService driveService;
    private final RepositoryService repositoryService;
    private final SpaceService spaceService;
    private final HTMLUploadImageProcessor imageProcessor;
    private String personalDriveName = "Personal Documents";

    public ActivityImageLinkUpdateListener(RepositoryService repositoryService, ActivityManager activityManager, IdentityManager identityManager, ManageDriveService driveService, SpaceService spaceService, HTMLUploadImageProcessor imageProcessor, InitParams params) {
        ValueParam personalDocumentsDriveName;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.driveService = driveService;
        this.repositoryService = repositoryService;
        this.spaceService = spaceService;
        this.imageProcessor = imageProcessor;
        if (params != null && (personalDocumentsDriveName = params.getValueParam(PERSONAL_DOCUMENTS_DRIVE_NAME_PARAM)) != null) {
            this.personalDriveName = personalDocumentsDriveName.getValue();
        }
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
    }

    public void updateComment(ActivityLifeCycleEvent event) {
    }

    public void likeComment(ActivityLifeCycleEvent event) {
    }

    private void updateImageLink(ActivityLifeCycleEvent event) throws Exception {
        Map templateParams;
        String processedTitle;
        String processedBody;
        ExoSocialActivity activity = event.getActivity();
        String body = activity.getBody();
        String title = activity.getTitle();
        boolean storeActivity = false;
        Node folderNode = this.getFolderNode(activity);
        if (StringUtils.isNotBlank((CharSequence)body) && !body.equals(processedBody = this.imageProcessor.processImages(body, folderNode, this.getImagesFolderPath(activity)))) {
            activity.setBody(processedBody);
            storeActivity = true;
        }
        if (StringUtils.isNotBlank((CharSequence)title) && !title.equals(processedTitle = this.imageProcessor.processImages(title, folderNode, this.getImagesFolderPath(activity)))) {
            activity.setTitle(processedTitle);
            storeActivity = true;
        }
        if ((templateParams = activity.getTemplateParams()) != null) {
            for (String param : templateParams.keySet()) {
                String processedParamValue;
                String paramValue = (String)templateParams.get(param);
                if (!StringUtils.isNotBlank((CharSequence)paramValue) || paramValue.equals(processedParamValue = this.imageProcessor.processImages(paramValue, folderNode, this.getImagesFolderPath(activity)))) continue;
                templateParams.put(param, processedParamValue);
                activity.setTemplateParams(templateParams);
                storeActivity = true;
            }
        }
        if (storeActivity) {
            this.activityManager.updateActivity(activity, false);
        }
    }

    private Node getFolderNode(ExoSocialActivity activity) throws Exception {
        String posterId = activity.getPosterId();
        String userName = this.identityManager.getIdentity(posterId, false).getRemoteId();
        DriveData selectedDriveData = null;
        if (activity.getActivityStream().getType() != null && "space".equals(activity.getActivityStream().getType().toString())) {
            String streamOwner = activity.getStreamOwner();
            Space space = this.spaceService.getSpaceByPrettyName(streamOwner);
            if (space == null) {
                LOG.warn("Can't find space with pretty name: {}. The uploaded files on activity {} will be ignored.", new Object[]{streamOwner, activity.getId()});
            }
            selectedDriveData = this.driveService.getDriveByName(space.getGroupId().replaceAll("/", "."));
        } else {
            List personalDrives = this.driveService.getPersonalDrives(userName);
            if (personalDrives == null || personalDrives.isEmpty()) {
                LOG.warn("The user {} hasn't personal drives, thus the uploaded files will be deleted from temporary folder", new Object[]{userName});
                return null;
            }
            for (DriveData driveData : personalDrives) {
                if (!this.personalDriveName.equals(driveData.getName())) continue;
                selectedDriveData = driveData;
                break;
            }
            if (selectedDriveData == null) {
                selectedDriveData = (DriveData)personalDrives.get(0);
                LOG.warn("Cannot find configured personal drive with name {}, another drive will be used instead: {}", new Object[]{this.personalDriveName, selectedDriveData.getName()});
            }
        }
        return this.getNode(selectedDriveData, userName);
    }

    private String getImagesFolderPath(ExoSocialActivity activity) {
        YearMonth yearMonth = YearMonth.now();
        int year = yearMonth.getYear();
        int month = yearMonth.getMonthValue();
        String monthString = String.format("%02d", month);
        String folderPath = activity.getActivityStream().getType() != null && "space".equals(activity.getActivityStream().getType().toString()) ? "Activity Stream Documents/Pictures/" + year + "/" + monthString : "Public/Activity Stream Documents/Pictures/" + year + "/" + monthString;
        return folderPath;
    }

    private Node getNode(DriveData driveData, String userId) throws Exception {
        String driveHomePath;
        Session session = this.getSession(driveData.getWorkspace());
        if (session == null) {
            return null;
        }
        String drivePath = driveHomePath = driveData.getHomePath();
        if (driveData.getName().equals(this.personalDriveName)) {
            drivePath = Utils.getPersonalDrivePath((String)driveHomePath, (String)userId);
        }
        Node node = (Node)session.getItem(Text.escapeIllegalJcrChars((String)drivePath));
        return node;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        if (sessionProvider == null) {
            return null;
        }
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        if (manageableRepository == null) {
            manageableRepository = this.repositoryService.getDefaultRepository();
        }
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }
}

