/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.ext.impl;

import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.SpaceStorageException;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/wiki/social-integration/plugin/space/WikiUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment")})
public class WikiUIActivity
extends BaseUIActivity {
    private static final Log LOG = ExoLogger.getLogger(WikiUIActivity.class);

    public String getUriOfAuthor() {
        if (this.getOwnerIdentity() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Failed to get Url of user, author isn't set");
            }
            return "";
        }
        return "<a href='" + this.getOwnerIdentity().getProfile().getUrl() + "'>" + this.getOwnerIdentity().getProfile().getFullName() + "</a>";
    }

    public String getUserFullName(String userId) {
        return this.getOwnerIdentity().getProfile().getFullName();
    }

    public String getUserProfileUri(String userId) {
        return this.getOwnerIdentity().getProfile().getUrl();
    }

    public String getUserAvatarImageSource(String userId) {
        return this.getOwnerIdentity().getProfile().getAvatarUrl();
    }

    public String getSpaceAvatarImageSource(String spaceIdentityId) {
        try {
            if (this.getOwnerIdentity() == null) {
                LOG.error((Object)"Failed to get Space Avatar Source, unknow owner identity.");
                return null;
            }
            String spaceId = this.getOwnerIdentity().getRemoteId();
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                return space.getAvatarUrl();
            }
        }
        catch (SpaceStorageException e) {
            LOG.error((Object)String.format("Failed to getSpaceById: %s. \n Cause by: ", spaceIdentityId), (Throwable)e);
        }
        return null;
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        return value != null ? value : "";
    }

    String getActivityMessage(WebuiBindingContext _ctx) throws Exception {
        String activityType = this.getActivityParamValue("act_key");
        if (activityType.equalsIgnoreCase("add_page")) {
            return _ctx.appRes("WikiUIActivity.label.page-create");
        }
        if ("update_page".equalsIgnoreCase(activityType)) {
            return _ctx.appRes("WikiUIActivity.label.page-update");
        }
        return "";
    }

    String getPageName() {
        return this.getActivityParamValue("page_name");
    }

    String getPageURL() {
        return this.getActivityParamValue("page_url");
    }

    String getViewChangeURL() {
        return this.getActivityParamValue("view_change_url");
    }

    String getPageExcerpt() {
        return this.getActivityParamValue("page_exceprt");
    }
}

