/*$DELIMITER:/ */
CREATE TABLE JCR_SITEM(
	ID VARCHAR(96) NOT NULL,
	PARENT_ID VARCHAR(96) NOT NULL,
	NAME VARCHAR(512) NOT NULL,
	VERSION INTEGER NOT NULL,
	CONTAINER_NAME VARCHAR(96) NOT NULL,
	I_CLASS INTEGER NOT NULL,
	I_INDEX INTEGER NOT NULL,
	N_ORDER_NUM INTEGER,
	P_TYPE INTEGER, 
	P_MULTIVALUED BOOLEAN,	
	CONSTRAINT JCR_PK_SITEM PRIMARY KEY(ID),
	CONSTRAINT JCR_FK_SITEM_PARENT FOREIGN KEY(PARENT_ID) REFERENCES JCR_SITEM(ID)
)/
CREATE UNIQUE INDEX JCR_IDX_SITEM_PARENT ON JCR_SITEM(CONTAINER_NAME, PARENT_ID, NAME, I_INDEX, I_CLASS, VERSION)/
CREATE UNIQUE INDEX JCR_IDX_SITEM_PARENT_NAME ON JCR_SITEM(I_CLASS, CONTAINER_NAME, PARENT_ID, NAME, I_INDEX, VERSION)/
CREATE UNIQUE INDEX JCR_IDX_SITEM_PARENT_ID ON JCR_SITEM(I_CLASS, CONTAINER_NAME, PARENT_ID, ID, VERSION)/
CREATE INDEX JCR_IDX_SITEM_PARENT_FK ON JCR_SITEM(PARENT_ID)/
CREATE INDEX JCR_IDX_SITEM_N_ORDER_NUM ON JCR_SITEM(I_CLASS, CONTAINER_NAME, PARENT_ID, N_ORDER_NUM)/
CREATE INDEX JCR_IDX_SITEM_NAME ON JCR_SITEM(I_CLASS, CONTAINER_NAME, NAME)/
CREATE TABLE JCR_SVALUE(
	ID BIGSERIAL NOT NULL, 
	DATA BYTEA,
	ORDER_NUM INTEGER NOT NULL,
	PROPERTY_ID VARCHAR(96) NOT NULL,
	STORAGE_DESC VARCHAR(512),
	CONSTRAINT JCR_PK_SVALUE PRIMARY KEY(ID),
	CONSTRAINT JCR_FK_SVALUE_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES JCR_SITEM(ID)
)/
CREATE UNIQUE INDEX JCR_IDX_SVALUE_PROPERTY ON JCR_SVALUE(PROPERTY_ID, ORDER_NUM)/
CREATE TABLE JCR_SREF(
    NODE_ID VARCHAR(96) NOT NULL,
    PROPERTY_ID VARCHAR(96) NOT NULL,
    ORDER_NUM INTEGER NOT NULL,
    CONSTRAINT JCR_PK_SREF PRIMARY KEY(NODE_ID, PROPERTY_ID, ORDER_NUM)
)/
CREATE UNIQUE INDEX JCR_IDX_SREF_PROPERTY ON JCR_SREF(PROPERTY_ID, ORDER_NUM)/
CREATE SEQUENCE JCR_SITEM_SEQ  INCREMENT BY 1 MINVALUE -1  NO MAXVALUE   NO CYCLE/
CREATE OR REPLACE FUNCTION JCR_SITEM_NEXT_VAL (nameSeq VARCHAR(20),newVal INTEGER, increment INTEGER)
RETURNS INTEGER AS $$
DECLARE
result INTEGER;
BEGIN
 IF (increment = 1)
 THEN
   SELECT nextval (nameSeq) INTO result;
 ELSIF (select nextval (nameSeq)) < newVal
 THEN
   SELECT setval(nameSeq, newVal +1, FALSE) INTO result;
 END IF;
 RETURN result;
END;
$$ LANGUAGE plpgsql/