/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.backupconsole;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.ws.rs.core.Response;
import org.exoplatform.jcr.backupconsole.BackupAgentResponse;
import org.exoplatform.jcr.backupconsole.BackupClient;
import org.exoplatform.jcr.backupconsole.BackupExecuteException;
import org.exoplatform.jcr.backupconsole.ClientTransport;
import org.exoplatform.jcr.backupconsole.FormAuthentication;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.server.bean.BackupConfigBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.BackupServiceInfoBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.DetailedInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfoList;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class BackupClientImpl
implements BackupClient {
    private static final int BLOCK_SIZE = 1024;
    private ClientTransport transport;
    private final String path;
    private FormAuthentication formAuthentication;

    public BackupClientImpl(ClientTransport transport, String urlPath) {
        this.transport = transport;
        this.path = urlPath == null ? "/rest" : urlPath;
    }

    public BackupClientImpl(ClientTransport transport, String login, String pass, String urlPath) {
        this.transport = transport;
        this.path = urlPath == null ? "/rest" : urlPath;
    }

    public BackupClientImpl(ClientTransport transport, FormAuthentication formAuthentication, String urlPath) {
        this(transport, urlPath);
        this.formAuthentication = formAuthentication;
    }

    @Override
    public String startBackUp(String repositoryName, String workspaceName, String backupDir) throws IOException, BackupExecuteException {
        JsonValue json;
        if (workspaceName != null) {
            JsonValue json2;
            String sURL = this.path + "/jcr-backup" + "/start" + "/" + repositoryName + "/" + workspaceName;
            BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(0), backupDir);
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            try {
                json2 = generatorImpl.createJsonObject((Object)bean);
            }
            catch (JsonException e) {
                throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
            }
            BackupAgentResponse response = this.transport.executePOST(sURL, json2.toString());
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
            }
            return this.failureProcessing(response);
        }
        String sURL = this.path + "/jcr-backup" + "/start-backup-repository" + "/" + repositoryName;
        BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(0), backupDir);
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        try {
            json = generatorImpl.createJsonObject((Object)bean);
        }
        catch (JsonException e) {
            throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
        }
        BackupAgentResponse response = this.transport.executePOST(sURL, json.toString());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    @Override
    public String startIncrementalBackUp(String repositoryName, String workspaceName, String backupDir, long incr) throws IOException, BackupExecuteException {
        JsonValue json;
        if (workspaceName != null) {
            JsonValue json2;
            String sURL = this.path + "/jcr-backup" + "/start" + "/" + repositoryName + "/" + workspaceName;
            BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(1), backupDir, Long.valueOf(incr));
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            try {
                json2 = generatorImpl.createJsonObject((Object)bean);
            }
            catch (JsonException e) {
                throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
            }
            BackupAgentResponse response = this.transport.executePOST(sURL, json2.toString());
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
            }
            return this.failureProcessing(response);
        }
        String sURL = this.path + "/jcr-backup" + "/start-backup-repository" + "/" + repositoryName;
        BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(1), backupDir, Long.valueOf(incr));
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        try {
            json = generatorImpl.createJsonObject((Object)bean);
        }
        catch (JsonException e) {
            throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
        }
        BackupAgentResponse response = this.transport.executePOST(sURL, json.toString());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    @Override
    public String status(String backupId) throws IOException, BackupExecuteException {
        String sURL = this.path + "/jcr-backup" + "/info/backup-repository-id" + "/" + backupId;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            sURL = this.path + "/jcr-backup" + "/info/backup" + "/" + backupId;
            response = this.transport.executeGET(sURL);
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            DetailedInfo info;
            try {
                info = (DetailedInfo)this.getObject(DetailedInfo.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get DetailedInfo from responce.", e);
            }
            if (info.getType() == 0) {
                StringBuilder result = new StringBuilder("\nThe completed (ready to restore) backup information : \n");
                BackupConfigBean configBean = info.getBackupConfig();
                result.append("\t\tbackup id               : ").append(info.getBackupId()).append("\n");
                result.append("\t\tbackup folder           : ").append(configBean.getBackupDir()).append("\n");
                result.append("\t\trepository name         : ").append(info.getRepositoryName()).append("\n");
                result.append(info.getWorkspaceName().equals("") ? "" : "\t\tworkspace name          : " + info.getWorkspaceName() + "\n");
                result.append("\t\tbackup type             : ");
                result.append(configBean.getBackupType() == 1 ? "full + incremental" : "full only");
                result.append("\n");
                result.append("\t\tstarted time            : ").append(info.getStartedTime()).append("\n");
                result.append(info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time           : " + info.getFinishedTime() + "\n\n");
                return result.toString();
            }
            StringBuilder result = new StringBuilder("\nThe current backup information : \n");
            BackupConfigBean configBean = info.getBackupConfig();
            result.append("\t\tbackup id                : ").append(info.getBackupId()).append("\n");
            result.append("\t\tbackup folder            : ").append(configBean.getBackupDir()).append("\n");
            result.append("\t\trepository name          : ").append(info.getRepositoryName()).append("\n");
            result.append(info.getWorkspaceName().equals("") ? "" : "\t\tworkspace name           : " + info.getWorkspaceName() + "\n");
            result.append("\t\tbackup type              : ");
            result.append(configBean.getBackupType() == 1 ? "full + incremental" : "full only");
            result.append("\n");
            result.append("\t\tfull backup state        : ");
            result.append(info.getWorkspaceName().equals("") ? this.getRepositoryBackupToFullState(info.getState()) : this.getState(info.getState()));
            result.append("\n");
            result.append(info.getBackupType() == 0 ? "" : "\t\tincremental backup state : working\n");
            result.append("\t\tstarted time             : ").append(info.getStartedTime()).append("\n");
            result.append(info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time            : " + info.getFinishedTime() + "\n\n");
            return result.toString();
        }
        return this.failureProcessing(response);
    }

    @Override
    public String stop(String backupId) throws IOException, BackupExecuteException {
        BackupAgentResponse workspaceResponse;
        String sURL = this.path + "/jcr-backup" + "/info/backup-repository/current";
        BackupAgentResponse repositoryResponse = this.transport.executeGET(sURL);
        if (repositoryResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList repositoryInfoList;
            try {
                repositoryInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, repositoryResponse.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get ShortInfoList from responce.", e);
            }
            for (ShortInfo info : repositoryInfoList.getBackups()) {
                if (!info.getBackupId().equals(backupId)) continue;
                sURL = this.path + "/jcr-backup" + "/stop-backup-repository" + "/" + backupId;
                BackupAgentResponse response = this.transport.executeGET(sURL);
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
                }
                return this.failureProcessing(response);
            }
        }
        if ((workspaceResponse = this.transport.executeGET(sURL = this.path + "/jcr-backup" + "/info/backup/current")).getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList workspaceInfoList;
            try {
                workspaceInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, workspaceResponse.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get ShortInfoList from responce.", e);
            }
            for (ShortInfo info : workspaceInfoList.getBackups()) {
                if (!info.getBackupId().equals(backupId)) continue;
                sURL = this.path + "/jcr-backup" + "/stop" + "/" + backupId;
                BackupAgentResponse response = this.transport.executeGET(sURL);
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
                }
                return this.failureProcessing(response);
            }
        }
        return "\nFailure :\n\tmessage      : There are no active backup with id  " + backupId;
    }

    @Override
    public String restore(String repositoryName, String workspaceName, String backupId, InputStream config, String backupSetPath, boolean removeExists) throws IOException, BackupExecuteException {
        BackupAgentResponse response = null;
        String sURL = null;
        String backupSetPathEncoded = null;
        if (backupSetPath != null) {
            backupSetPathEncoded = URLEncoder.encode(backupSetPath, "UTF-8");
        }
        if (workspaceName != null) {
            if (config != null) {
                JsonValue json;
                if (backupId != null) {
                    sURL = this.path + "/jcr-backup" + "/restore" + "/" + repositoryName + "/" + backupId + "/" + removeExists;
                } else if (backupSetPath != null) {
                    sURL = this.path + "/jcr-backup" + "/restore/backup-set" + "/" + repositoryName + "/" + removeExists + "?backup-set-path=" + backupSetPathEncoded;
                }
                WorkspaceEntry wEntry = null;
                try {
                    wEntry = this.getWorkspaceEntry(config, repositoryName, workspaceName);
                }
                catch (Throwable e) {
                    throw new BackupExecuteException("Can not get WorkspaceEntry for workspace '" + workspaceName + "' from config.", e);
                }
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                try {
                    json = generatorImpl.createJsonObject((Object)wEntry);
                }
                catch (JsonException e) {
                    throw new BackupExecuteException("Can not get json from  : " + wEntry.getClass().toString(), e);
                }
                response = this.transport.executePOST(sURL, json.toString());
            } else {
                response = new BackupAgentResponse("The workspace configuration cannot be found".getBytes("UTF-8"), 500);
            }
        } else if (repositoryName != null) {
            if (config != null) {
                JsonValue json;
                if (backupId != null) {
                    sURL = this.path + "/jcr-backup" + "/restore-repository" + "/" + backupId + "/" + removeExists;
                } else if (backupSetPath != null) {
                    sURL = this.path + "/jcr-backup" + "/restore-repository/backup-set" + "/" + removeExists + "?backup-set-path=" + backupSetPathEncoded;
                }
                RepositoryEntry wEntry = null;
                try {
                    wEntry = this.getRepositoryEntry(config, repositoryName);
                }
                catch (Throwable e) {
                    throw new BackupExecuteException("Can not get RepositoryEntry for repository '" + repositoryName + "' from config.", e);
                }
                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                try {
                    json = generatorImpl.createJsonObject((Object)wEntry);
                }
                catch (JsonException e) {
                    throw new BackupExecuteException("Can not get json from  : " + wEntry.getClass().toString(), e);
                }
                response = this.transport.executePOST(sURL, json.toString());
            } else {
                response = new BackupAgentResponse("The workspace configuration cannot be found".getBytes("UTF-8"), 500);
            }
        } else {
            if (backupId != null) {
                boolean isRepository = true;
                String lsURL = this.path + "/jcr-backup" + "/info/backup-repository-id" + "/" + backupId;
                BackupAgentResponse lResponse = this.transport.executeGET(lsURL);
                if (lResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                    sURL = this.path + "/jcr-backup" + "/info/backup" + "/" + backupId;
                    lResponse = this.transport.executeGET(sURL);
                    if (lResponse.getStatus() == Response.Status.OK.getStatusCode()) {
                        isRepository = false;
                    } else {
                        return this.failureProcessing(lResponse);
                    }
                }
                sURL = isRepository ? this.path + "/jcr-backup" + "/restore-repository" + "/" + backupId + "/" + removeExists : this.path + "/jcr-backup" + "/restore" + "/" + backupId + "/" + removeExists;
            } else if (backupSetPath != null) {
                sURL = this.path + "/jcr-backup" + "/restore/backup-set" + "/" + removeExists + "?backup-set-path=" + backupSetPathEncoded;
            }
            response = this.transport.executeGET(sURL);
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    @Override
    public String drop(boolean forceClose, String repositoryName, String workspaceName) throws IOException, BackupExecuteException {
        if (workspaceName != null) {
            String sURL = this.path + "/jcr-backup" + "/drop-workspace" + "/" + repositoryName + "/" + workspaceName + "/" + forceClose;
            BackupAgentResponse response = this.transport.executeGET(sURL);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
            }
            return this.failureProcessing(response);
        }
        String sURL = this.path + "/jcr-service" + "/remove-repository" + "/" + repositoryName + "/" + forceClose;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    @Override
    public String info() throws IOException, BackupExecuteException {
        String sURL = this.path + "/jcr-backup" + "/info";
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            BackupServiceInfoBean info;
            try {
                info = (BackupServiceInfoBean)this.getObject(BackupServiceInfoBean.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get BackupServiceInfoBean from responce.", e);
            }
            String result = "\nThe backup service information : \n\tfull backup type               : " + info.getFullBackupType() + "\n\tincremental backup type        : " + info.getIncrementalBackupType() + "\n\tbackup log folder              : " + info.getBackupLogDir() + "\n\tdefault incremental job period : " + info.getDefaultIncrementalJobPeriod() + "\n\n";
            return result;
        }
        return this.failureProcessing(response);
    }

    @Override
    public String list() throws IOException, BackupExecuteException {
        String sURL = this.path + "/jcr-backup" + "/info/backup-repository/current";
        BackupAgentResponse repositoryResponse = this.transport.executeGET(sURL);
        sURL = this.path + "/jcr-backup" + "/info/backup/current";
        BackupAgentResponse workspaceResponse = this.transport.executeGET(sURL);
        if (repositoryResponse.getStatus() == Response.Status.OK.getStatusCode() && workspaceResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList workspaceInfoList;
            ShortInfoList repositoryInfoList;
            try {
                repositoryInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, repositoryResponse.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get ShortInfoList from responce.", e);
            }
            try {
                workspaceInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, workspaceResponse.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get ShortInfoList from responce.", e);
            }
            StringBuilder result = new StringBuilder("\nThe current backups information : \n");
            if (repositoryInfoList.getBackups().size() == 0 && workspaceInfoList.getBackups().size() == 0) {
                result.append("\tNo active backups.\n\n");
            }
            int count = 1;
            for (ShortInfo shortInfo : repositoryInfoList.getBackups()) {
                result.append("\t").append(count).append(") Repository backup with id ").append(shortInfo.getBackupId()).append(" :\n");
                result.append("\t\trepository name            : ").append(shortInfo.getRepositoryName()).append("\n");
                result.append("\t\tbackup type                : ");
                result.append(shortInfo.getBackupType() == 1 ? "full + incremental" : "full only");
                result.append("\n");
                result.append("\t\tfull backups state         : ").append(this.getRepositoryBackupToFullState(shortInfo.getState())).append("\n");
                result.append(shortInfo.getBackupType() == 0 ? "" : "\t\tincremental backups state  : working\n");
                result.append("\t\tstarted time               : ").append(shortInfo.getStartedTime()).append("\n");
                result.append(shortInfo.getFinishedTime().equals("") ? "" : "\t\tfinished time              : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            for (ShortInfo shortInfo : workspaceInfoList.getBackups()) {
                result.append("\t").append(count).append(") Workspace backup with id ").append(shortInfo.getBackupId()).append(" :\n");
                result.append("\t\trepository name            : ").append(shortInfo.getRepositoryName()).append("\n");
                result.append("\t\tworkspace name             : ").append(shortInfo.getWorkspaceName()).append("\n");
                result.append("\t\tbackup type                : ");
                result.append(shortInfo.getBackupType() == 1 ? "full + incremental" : "full only").append("\n");
                result.append("\t\tfull backup state          : ").append(this.getState(shortInfo.getState())).append("\n");
                result.append(shortInfo.getBackupType() == 0 ? "" : "\t\tincremental backup state   : working\n");
                result.append("\t\tstarted time               : ").append(shortInfo.getStartedTime()).append("\n");
                result.append(shortInfo.getFinishedTime().equals("") ? "" : "\t\tfinished time              : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            return result.toString();
        }
        return this.failureProcessing(workspaceResponse);
    }

    @Override
    public String listCompleted() throws IOException, BackupExecuteException {
        String sURL = this.path + "/jcr-backup" + "/info/backup-repository/completed";
        BackupAgentResponse repositoryResponse = this.transport.executeGET(sURL);
        sURL = this.path + "/jcr-backup" + "/info/backup/completed";
        BackupAgentResponse workspaceResponse = this.transport.executeGET(sURL);
        if (workspaceResponse.getStatus() == Response.Status.OK.getStatusCode() && repositoryResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList workspaceInfoList;
            ShortInfoList repositoryInfoList;
            try {
                repositoryInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, repositoryResponse.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get ShortInfoList from responce.", e);
            }
            try {
                workspaceInfoList = (ShortInfoList)this.getObject(ShortInfoList.class, workspaceResponse.getResponseData());
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get ShortInfoList from responce.", e);
            }
            StringBuilder result = new StringBuilder("\nThe completed (ready to restore) backups information : \n");
            if (repositoryInfoList.getBackups().size() == 0 && workspaceInfoList.getBackups().size() == 0) {
                result.append("\tNo completed backups.\n\n");
            }
            int count = 1;
            for (ShortInfo shortInfo : repositoryInfoList.getBackups()) {
                result.append("\t").append(count).append(") Repository backup with id ").append(shortInfo.getBackupId()).append(" :\n");
                result.append("\t\trepository name           : ").append(shortInfo.getRepositoryName()).append("\n");
                result.append("\t\tbackup type               : ");
                result.append(shortInfo.getBackupType() == 1 ? "full + incremental" : "full only").append("\n");
                result.append("\t\tstarted time              : ").append(shortInfo.getStartedTime()).append("\n");
                result.append(shortInfo.getFinishedTime().equals("") ? "\n" : "\t\tfinished time             : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            for (ShortInfo shortInfo : workspaceInfoList.getBackups()) {
                result.append("\t").append(count).append(") Workspace backup with id ").append(shortInfo.getBackupId()).append(" :\n");
                result.append("\t\trepository name           : ").append(shortInfo.getRepositoryName()).append("\n");
                result.append("\t\tworkspace name            : ").append(shortInfo.getWorkspaceName()).append("\n");
                result.append("\t\tbackup type               : ");
                result.append(shortInfo.getBackupType() == 1 ? "full + incremental" : "full only").append("\n");
                result.append("\t\tstarted time              : ").append(shortInfo.getStartedTime()).append("\n");
                result.append(shortInfo.getFinishedTime().equals("") ? "\n" : "\t\tfinished time             : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            return result.toString();
        }
        return this.failureProcessing(workspaceResponse);
    }

    @Override
    public String restores(String repositoryName, String workspaceName) throws IOException, BackupExecuteException {
        if (workspaceName != null) {
            String sURL = this.path + "/jcr-backup" + "/info/restore" + "/" + repositoryName + "/" + workspaceName;
            BackupAgentResponse response = this.transport.executeGET(sURL);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                DetailedInfo info;
                try {
                    info = (DetailedInfo)this.getObject(DetailedInfo.class, response.getResponseData());
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can not get DetailedInfo from responce.", e);
                }
                StringBuilder result = new StringBuilder("\nThe current restores information : \n");
                result.append("\tWorkspace restore with id ").append(info.getBackupId()).append(":\n");
                BackupConfigBean configBean = info.getBackupConfig();
                result.append("\t\tbackup folder           : ").append(configBean.getBackupDir()).append("\n");
                result.append("\t\trepository name         : ").append(info.getRepositoryName()).append("\n");
                result.append("\t\tworkspace name          : ").append(info.getWorkspaceName()).append("\n");
                result.append("\t\tbackup type             : ");
                result.append(configBean.getBackupType() == 1 ? "full + incremental" : "full only").append("\n");
                result.append("\t\trestore state           : ").append(this.getRestoreState(info.getState())).append("\n");
                result.append("\t\tstarted time            : ").append(info.getStartedTime()).append("\n");
                result.append(info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time           : " + info.getFinishedTime() + "\n\n");
                return result.toString();
            }
            return this.failureProcessing(response);
        }
        String sURL = this.path + "/jcr-backup" + "/info/restore-repository" + "/" + repositoryName;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            DetailedInfo info;
            try {
                info = (DetailedInfo)this.getObject(DetailedInfo.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new IllegalStateException("Can not get DetailedInfo from responce.", e);
            }
            StringBuilder result = new StringBuilder("\nThe current restores information : \n");
            result.append("\tRepository restore with id ").append(info.getBackupId()).append(":\n");
            BackupConfigBean configBean = info.getBackupConfig();
            result.append("\t\tbackup folder           : ").append(configBean.getBackupDir()).append("\n");
            result.append("\t\trepository name         : ").append(info.getRepositoryName()).append("\n");
            result.append("\t\tbackup type             : ");
            result.append(configBean.getBackupType() == 1 ? "full + incremental" : "full only").append("\n");
            result.append("\t\trestore state           : ").append(this.getRepositoryRestoreState(info.getState())).append("\n");
            result.append("\t\tstarted time            : ").append(info.getStartedTime()).append("\n");
            result.append(info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time           : " + info.getFinishedTime() + "\n\n");
            return result.toString();
        }
        return this.failureProcessing(response);
    }

    private Object getObject(Class cl, byte[] data) throws Exception {
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        JsonParserImpl jsonParser = new JsonParserImpl();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        return new BeanBuilder().createObject(cl, jsonValue);
    }

    private String getRestoreState(int restoreState) {
        String state = "unknown sate of restore";
        switch (restoreState) {
            case 4: {
                state = "initialized";
                break;
            }
            case 1: {
                state = "started";
                break;
            }
            case 2: {
                state = "successful";
                break;
            }
            case 3: {
                state = "fail";
                break;
            }
        }
        return state;
    }

    private String getRepositoryRestoreState(int restoreState) {
        String state = "unknown sate of restore";
        switch (restoreState) {
            case 4: {
                state = "initialized";
                break;
            }
            case 1: {
                state = "started";
                break;
            }
            case 2: {
                state = "successful";
                break;
            }
            case 3: {
                state = "fail";
                break;
            }
        }
        return state;
    }

    private String getState(int state) {
        String st = "";
        switch (state) {
            case 4: {
                st = "finished";
                break;
            }
            case 2: {
                st = "working";
                break;
            }
            case 1: {
                st = "waiting";
                break;
            }
            case 0: {
                st = "starting";
                break;
            }
        }
        return st;
    }

    private String getRepositoryBackupToFullState(int state) {
        String st = "";
        switch (state) {
            case 4: {
                st = "finished";
                break;
            }
            case 8: {
                st = "working";
                break;
            }
            case 0: {
                st = "initialized";
                break;
            }
            case 16: {
                st = "finished";
                break;
            }
        }
        return st;
    }

    private String failureProcessing(BackupAgentResponse response) throws BackupExecuteException {
        try {
            String result = "\nFailure :\n\tstatus code : " + response.getStatus() + "\n\tmessage      : " + new String(response.getResponseData(), "UTF-8") + "\n\n";
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new BackupExecuteException("Can not encoded the responce : " + e.getMessage(), e);
        }
    }

    private RepositoryEntry getRepositoryEntry(InputStream wEntryStream, String repositoryName) throws FileNotFoundException, JiBXException, RepositoryConfigurationException {
        IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
        IUnmarshallingContext uctx = factory.createUnmarshallingContext();
        RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument(wEntryStream, null);
        RepositoryEntry rEntry = conf.getRepositoryConfiguration(repositoryName);
        return rEntry;
    }

    private WorkspaceEntry getWorkspaceEntry(InputStream wEntryStream, String repositoryName, String workspaceName) throws FileNotFoundException, JiBXException, RepositoryConfigurationException {
        RepositoryEntry rEntry = this.getRepositoryEntry(wEntryStream, repositoryName);
        WorkspaceEntry wsEntry = null;
        for (WorkspaceEntry wEntry : rEntry.getWorkspaceEntries()) {
            if (!wEntry.getName().equals(workspaceName)) continue;
            wsEntry = wEntry;
        }
        if (wsEntry == null) {
            throw new IllegalStateException("Can not find the workspace '" + workspaceName + "' in configuration.");
        }
        return wsEntry;
    }
}

