/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.jcr.browser;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;
import org.exoplatform.services.jcr.ext.replication.async.executor.AsyncReplicationExecutor;
import org.exoplatform.services.jcr.ext.replication.async.executor.AsyncReplicationExecutorException;
import org.exoplatform.services.log.ExoLogger;

public class JCRBrowser {
    private static final Log LOG = ExoLogger.getLogger((String)"samples.JCRBrowser");
    protected RepositoryService repositoryService;
    protected ManageableRepository repository;
    protected Session session;
    protected Node node;
    protected List<String> errors = new ArrayList();

    public ManageableRepository getRepository() {
        return this.repository;
    }

    public void setRepository(ManageableRepository repository) {
        this.repository = repository;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) throws RepositoryException {
        this.session = session;
        this.node = this.session.getRootNode();
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void addError(Throwable error) {
        this.errors.add(error.toString());
    }

    public boolean isErrorsFound() {
        return this.errors.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getErrorsAndClean() {
        try {
            String[] errs = new String[this.errors.size()];
            this.errors.toArray(errs);
            String[] stringArray = errs;
            return stringArray;
        }
        finally {
            this.errors.clear();
        }
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean isAsynchronousReplicationPresent() {
        return this.getAsynchronousReplication() != null;
    }

    public boolean isAsynchronousReplicationActive() {
        AsyncReplication arep = this.getAsynchronousReplication();
        return arep != null && arep.isActive();
    }

    public void runSynchronization() {
        block5: {
            AsyncReplicationExecutor arep = this.getAsynchronousReplicationExecutor();
            if (arep != null) {
                try {
                    long start = System.currentTimeMillis();
                    if (arep.synchronize()) {
                        LOG.info((Object)("Synchronization started " + new Date() + ", " + (System.currentTimeMillis() - start) / 1000L + "sec."));
                        break block5;
                    }
                    LOG.info((Object)("Synchronization star failed. " + (System.currentTimeMillis() - start) / 1000L + "sec."));
                }
                catch (AsyncReplicationExecutorException e) {
                    LOG.error((Object)("Synchronization fails. Repository error " + (Object)((Object)e)), (Throwable)e);
                }
            } else {
                LOG.warn((Object)"Synchronization impossible. Service is not present.");
            }
        }
    }

    private AsyncReplication getAsynchronousReplication() {
        WorkspaceContainerFacade container;
        if (this.repository != null && (container = this.repository.getWorkspaceContainer(this.repository.getConfiguration().getDefaultWorkspaceName())) != null) {
            return (AsyncReplication)container.getComponent(AsyncReplication.class);
        }
        return null;
    }

    private AsyncReplicationExecutor getAsynchronousReplicationExecutor() {
        WorkspaceContainerFacade container;
        if (this.repository != null && (container = this.repository.getWorkspaceContainer(this.repository.getConfiguration().getDefaultWorkspaceName())) != null) {
            return (AsyncReplicationExecutor)container.getComponent(AsyncReplicationExecutor.class);
        }
        return null;
    }
}

