/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.filters.jcr;

import java.util.Enumeration;
import javax.jcr.Repository;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.auth.AuthenticationService;
import org.exoplatform.services.organization.auth.Identity;

/*
 * Exception performing whole class analysis ignored.
 */
public class Helper {
    private static Log log = ExoLogger.getLogger((String)"jcr.Helper");

    public static Repository requestRepository(HttpServletRequest httpRequest, String repoName, boolean useRmi) throws Exception {
        Repository repository = null;
        if (repoName == null) {
            repository = (Repository)httpRequest.getSession().getAttribute("repo");
        }
        if (repository == null) {
            System.out.println("use rmi=" + useRmi + " reponame=" + repoName);
            InitialContext ctx = new InitialContext();
            try {
                Object obj = ctx.lookup(repoName);
                if (obj instanceof Repository) {
                    repository = (Repository)obj;
                } else {
                    obj = ctx.lookup("java:comp/env/" + repoName);
                    if (obj instanceof Repository) {
                        repository = (Repository)obj;
                    } else {
                        log.info((Object)("Can't cast object " + obj + " as Repository class object"));
                    }
                }
            }
            catch (NamingException e) {
                System.err.println("Repository not bound in JNDI with name '" + repoName + "', " + e.getMessage());
                repository = (Repository)ctx.lookup("java:comp/env/jcr/" + repoName);
            }
        }
        StandaloneContainer container_ = StandaloneContainer.getInstance();
        RepositoryService repositoryService = (RepositoryService)container_.getComponentInstanceOfType(RepositoryService.class);
        if (!useRmi) {
            repositoryService.setCurrentRepositoryName(repoName);
        }
        httpRequest.getSession().setAttribute("repo", (Object)repository);
        return repository;
    }

    public static void removeAttributes(HttpSession session) {
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            session.removeAttribute(key);
        }
    }

    private static void setUser(HttpServletRequest request_) throws Exception {
        StandaloneContainer container_ = StandaloneContainer.getInstance();
        HttpSession session = request_.getSession();
        AuthenticationService authenticationService = (AuthenticationService)container_.getComponentInstanceOfType(AuthenticationService.class);
        if (request_.getRemoteUser() != null && authenticationService.getCurrentIdentity() == null) {
            log.error((Object)("Cannot find the identity for user " + request_.getRemoteUser() + ", trying to create the new one"));
            Identity identity = authenticationService.getIdentityBySessionId(request_.getRemoteUser());
            authenticationService.setCurrentIdentity(identity);
        }
    }

    public static void tuneRequest(HttpServletRequest request_) {
        try {
            Helper.setUser((HttpServletRequest)request_);
        }
        catch (Exception e) {
            log.error((Object)("tuneRequest error for " + request_.getRemoteUser()), (Throwable)e);
        }
    }
}

