/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;

public class CMSEnvelopedDataGenerator
extends CMSEnvelopedGenerator {
    private CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        BERConstructedOctetString bERConstructedOctetString;
        AlgorithmIdentifier algorithmIdentifier;
        ASN1Encodable aSN1Encodable;
        Object object;
        SecretKey secretKey;
        Object object2;
        String string3 = keyGenerator.getProvider().getName();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            Object object3;
            Object object4;
            object2 = Cipher.getInstance(string, string3);
            secretKey = keyGenerator.generateKey();
            try {
                object4 = AlgorithmParameterGenerator.getInstance(string, string3);
                if (string.equals(RC2_CBC)) {
                    object3 = new byte[8];
                    this.rand.setSeed(System.currentTimeMillis());
                    this.rand.nextBytes((byte[])object3);
                    ((AlgorithmParameterGenerator)object4).init(new RC2ParameterSpec(secretKey.getEncoded().length * 8, (byte[])object3));
                }
                object = ((AlgorithmParameterGenerator)object4).generateParameters();
                object3 = new ASN1InputStream(((AlgorithmParameters)object).getEncoded("ASN.1"));
                aSN1Encodable = ((ASN1InputStream)object3).readObject();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                object = null;
                aSN1Encodable = new DERNull();
            }
            algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), aSN1Encodable);
            ((Cipher)object2).init(1, (Key)secretKey, (AlgorithmParameters)object);
            object4 = new ByteArrayOutputStream();
            object3 = new CipherOutputStream((OutputStream)object4, (Cipher)object2);
            cMSProcessable.write((OutputStream)object3);
            ((CipherOutputStream)object3).close();
            bERConstructedOctetString = new BERConstructedOctetString(((ByteArrayOutputStream)object4).toByteArray());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        object2 = this.recipientInfs.iterator();
        while (object2.hasNext()) {
            object = (CMSEnvelopedGenerator.RecipientInf)object2.next();
            try {
                aSN1EncodableVector.add(((CMSEnvelopedGenerator.RecipientInf)object).toRecipientInfo(secretKey, string2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object = new EncryptedContentInfo(PKCSObjectIdentifiers.data, algorithmIdentifier, bERConstructedOctetString);
        aSN1Encodable = new ContentInfo(PKCSObjectIdentifiers.envelopedData, new EnvelopedData(null, new DERSet(aSN1EncodableVector), (EncryptedContentInfo)object, null));
        return new CMSEnvelopedData((ContentInfo)aSN1Encodable);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createKeyGenerator(string, string2);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }

    public CMSEnvelopedData generate(CMSProcessable cMSProcessable, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createKeyGenerator(string, string2);
        keyGenerator.init(n);
        return this.generate(cMSProcessable, string, keyGenerator, string2);
    }
}

