/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.common.http.client;

import java.io.IOException;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.common.http.client.HTTPClientModule;
import org.exoplatform.common.http.client.HttpHeaderElement;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.common.http.client.ParseException;
import org.exoplatform.common.http.client.Request;
import org.exoplatform.common.http.client.Response;
import org.exoplatform.common.http.client.RoRequest;
import org.exoplatform.common.http.client.UncompressInputStream;
import org.exoplatform.common.http.client.Util;
import org.exoplatform.services.log.ExoLogger;

class ContentEncodingModule
implements HTTPClientModule {
    private static final Log log = ExoLogger.getLogger("ws.commons.httpclient.ContentEncodingModule");

    ContentEncodingModule() {
    }

    public int requestHandler(Request req, Response[] resp) throws ModuleException {
        Vector<HttpHeaderElement> pae;
        int idx;
        NVPair[] hdrs = req.getHeaders();
        for (idx = 0; idx < hdrs.length && !hdrs[idx].getName().equalsIgnoreCase("Accept-Encoding"); ++idx) {
        }
        if (idx == hdrs.length) {
            hdrs = Util.resizeArray(hdrs, idx + 1);
            req.setHeaders(hdrs);
            pae = new Vector<HttpHeaderElement>();
        } else {
            try {
                pae = Util.parseHeader(hdrs[idx].getValue());
            }
            catch (ParseException pe) {
                throw new ModuleException(pe.toString());
            }
        }
        HttpHeaderElement all = Util.getElement(pae, "*");
        if (all != null) {
            NVPair[] params = all.getParams();
            for (idx = 0; idx < params.length && !params[idx].getName().equalsIgnoreCase("q"); ++idx) {
            }
            if (idx == params.length) {
                return 0;
            }
            if (params[idx].getValue() == null || params[idx].getValue().length() == 0) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: ");
            }
            try {
                if ((double)Float.valueOf(params[idx].getValue()).floatValue() > 0.0) {
                    return 0;
                }
            }
            catch (NumberFormatException nfe) {
                throw new ModuleException("Invalid q value for \"*\" in Accept-Encoding header: " + nfe.getMessage());
            }
        }
        if (!pae.contains(new HttpHeaderElement("deflate"))) {
            pae.addElement(new HttpHeaderElement("deflate"));
        }
        if (!pae.contains(new HttpHeaderElement("gzip"))) {
            pae.addElement(new HttpHeaderElement("gzip"));
        }
        if (!pae.contains(new HttpHeaderElement("x-gzip"))) {
            pae.addElement(new HttpHeaderElement("x-gzip"));
        }
        if (!pae.contains(new HttpHeaderElement("compress"))) {
            pae.addElement(new HttpHeaderElement("compress"));
        }
        if (!pae.contains(new HttpHeaderElement("x-compress"))) {
            pae.addElement(new HttpHeaderElement("x-compress"));
        }
        hdrs[idx] = new NVPair("Accept-Encoding", Util.assembleHeader(pae));
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) {
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) throws IOException, ModuleException {
        Vector pce;
        String ce = resp.getHeader("Content-Encoding");
        if (ce == null || req.getMethod().equals("HEAD") || resp.getStatusCode() == 206) {
            return;
        }
        try {
            pce = Util.parseHeader(ce);
        }
        catch (ParseException pe) {
            throw new ModuleException(pe.toString());
        }
        if (pce.size() == 0) {
            return;
        }
        String encoding = ((HttpHeaderElement)pce.firstElement()).getName();
        if (encoding.equalsIgnoreCase("gzip") || encoding.equalsIgnoreCase("x-gzip")) {
            if (log.isDebugEnabled()) {
                log.debug("Pushing gzip-input-stream");
            }
            resp.inp_stream = new GZIPInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("deflate")) {
            if (log.isDebugEnabled()) {
                log.debug("Pushing inflater-input-stream");
            }
            resp.inp_stream = new InflaterInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("compress") || encoding.equalsIgnoreCase("x-compress")) {
            if (log.isDebugEnabled()) {
                log.debug("Pushing uncompress-input-stream");
            }
            resp.inp_stream = new UncompressInputStream(resp.inp_stream);
            pce.removeElementAt(pce.size() - 1);
            resp.deleteHeader("Content-length");
        } else if (encoding.equalsIgnoreCase("identity")) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring 'identity' token");
            }
            pce.removeElementAt(pce.size() - 1);
        } else if (log.isDebugEnabled()) {
            log.debug("Unknown content encoding '" + encoding + "'");
        }
        if (pce.size() > 0) {
            resp.setHeader("Content-Encoding", Util.assembleHeader(pce));
        } else {
            resp.deleteHeader("Content-Encoding");
        }
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

