/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.cli;

import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.frameworks.jcr.cli.AbstractCliCommand;
import org.exoplatform.frameworks.jcr.cli.CliAppContext;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;

public class GetContextInfoCommand
extends AbstractCliCommand {
    public boolean perform(CliAppContext ctx) {
        String output = "";
        try {
            output = "Context info: \n";
            Item item = ctx.getCurrentItem();
            ItemDefinition itemDefinition = item.isNode() ? ((NodeImpl)item).getDefinition() : ((PropertyImpl)item).getDefinition();
            output = output + "username: " + ctx.getUserName() + "\n";
            output = output + "workspace: " + ctx.getCurrentWorkspace() + "\n";
            output = output + "item path: " + item.getPath() + "\n";
            String itemType = item.isNode() ? "Node" : "Property";
            output = output + "item type: " + itemType + "\n";
            output = output + "item definitions:\n";
            output = output + "  name: " + itemDefinition.getName() + "\n";
            output = output + "  autocreated:" + itemDefinition.isAutoCreated() + "\n";
            output = output + "  mandatory:" + itemDefinition.isMandatory() + "\n";
            output = output + "  protected:" + itemDefinition.isProtected() + "\n";
            output = output + "  onparentversion:" + itemDefinition.getOnParentVersion() + "\n";
            if (!item.isNode()) {
                PropertyDefinition propertyDefinition;
                Property property = (Property)item;
                int propertyType = property.getValue().getType();
                output = propertyType != 2 ? (!(propertyDefinition = (PropertyDefinition)itemDefinition).isMultiple() ? output + "property value:" + property.getValue().getString() + "\n" : output + "property value is multiple\n") : output + "can't show property value:\n";
            }
            output = output + "parameters:\n";
            Iterator<String> parametersIterator = ctx.getParameters().iterator();
            int i = 0;
            while (parametersIterator.hasNext()) {
                output = output + "  [" + i + "]" + " : " + parametersIterator.next() + "\n";
                ++i;
            }
        }
        catch (Exception e) {
            output = "Can't execute command - " + e.getMessage() + "\n";
        }
        ctx.setOutput(output);
        return false;
    }
}

