/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command.core;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.frameworks.jcr.command.JCRAppContext;

public class SetPropertyCommand
implements Command {
    private String nameKey = "name";
    private String currentNodeKey = "currentNode";
    private String resultKey = "result";
    private String propertyTypeKey = "propertyType";
    private String valuesKey = "values";
    private String multiValuedKey = "multiValued";

    public boolean execute(Context context) throws Exception {
        Session session = ((JCRAppContext)context).getSession();
        Node parentNode = (Node)session.getItem((String)context.get(this.currentNodeKey));
        String name = (String)context.get(this.nameKey);
        int type = PropertyType.valueFromName((String)context.get(this.propertyTypeKey));
        if (context.get(this.multiValuedKey).equals("true")) {
            boolean multi = true;
        } else {
            boolean multi = false;
        }
        Object values = context.get(this.valuesKey);
        if (values instanceof String) {
            context.put(this.resultKey, parentNode.setProperty(name, (String)values, type));
        } else if (values instanceof String[]) {
            context.put(this.resultKey, parentNode.setProperty(name, (String[])values, type));
        } else if (values instanceof InputStream) {
            context.put(this.resultKey, parentNode.setProperty(name, (InputStream)values));
        } else {
            throw new Exception("Values other than String, String[], InputStream is not supported");
        }
        return false;
    }
}

