/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command.web;

import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.frameworks.jcr.command.JCRCommandHelper;
import org.exoplatform.frameworks.jcr.command.web.GenericWebAppContext;

public class DisplayResourceCommand
implements Command {
    public static String DEFAULT_MAPPING = "/jcr";
    public static String DEFAULT_ENCODING = "UTF-8";
    private String pathKey = "path";

    public boolean execute(Context context) throws Exception {
        Property data;
        GenericWebAppContext webCtx = (GenericWebAppContext)context;
        HttpServletResponse response = webCtx.getResponse();
        HttpServletRequest request = webCtx.getRequest();
        String servletPath = request.getPathInfo();
        boolean doClose = true;
        if (servletPath == null && (servletPath = (String)request.getAttribute("javax.servlet.include.path_info")) != null) {
            doClose = false;
        }
        Node file = (Node)webCtx.getSession().getItem((String)context.get(this.pathKey));
        file.refresh(false);
        Node content = null;
        try {
            content = JCRCommandHelper.getNtResourceRecursively(file);
        }
        catch (ItemNotFoundException e) {
            if (file.isNodeType("exo:article")) {
                try {
                    content = file.getNode("exo:image");
                }
                catch (PathNotFoundException e1) {
                    throw e;
                }
            }
            throw e;
        }
        try {
            data = content.getProperty("jcr:data");
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundException("No jcr:data node found at " + content.getPath());
        }
        String mime = content.getProperty("jcr:mimeType").getString();
        String encoding = content.hasProperty("jcr:encoding") ? content.getProperty("jcr:encoding").getString() : DEFAULT_ENCODING;
        MimeTypeResolver resolver2 = new MimeTypeResolver();
        String fileName = file.getName();
        String fileExt = "";
        if (fileName.lastIndexOf(".") > -1) {
            fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        String mimeExt = resolver2.getExtension(mime);
        if (fileExt == null || fileExt.length() == 0) {
            fileExt = mimeExt;
        }
        response.setContentType(mime + "; charset=" + encoding);
        String parameter = (String)context.get("cache-control-max-age");
        String cacheControl = parameter == null ? "" : "public, max-age=" + parameter;
        response.setHeader("Cache-Control: ", cacheControl);
        response.setHeader("Pragma: ", "");
        response.setHeader("Content-disposition", "attachment; filename=\"" + fileName + "." + fileExt + "\"");
        if (mime.startsWith("text")) {
            PrintWriter out = response.getWriter();
            out.write(data.getString());
            out.flush();
            if (doClose) {
                out.close();
            }
        } else {
            InputStream is = data.getStream();
            byte[] buf = new byte[is.available()];
            is.read(buf);
            ServletOutputStream os = response.getOutputStream();
            os.write(buf);
            os.flush();
            if (doClose) {
                os.close();
            }
        }
        return true;
    }

    public String getPathKey() {
        return this.pathKey;
    }
}

