/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;

public class LoggingCacheListener
implements CacheListener {
    Log log = ExoLogger.getLogger("kernel.cache.log");

    public void onClearCache(ExoCache cache) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cleared region " + cache.getName());
        }
    }

    public void onExpire(ExoCache cache, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Expired entry " + key + " on region " + cache.getName());
        }
    }

    public void onGet(ExoCache cache, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Get entry " + key + " on region " + cache.getName());
        }
    }

    public void onPut(ExoCache cache, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Put entry " + key + " region " + cache.getName());
        }
        if (this.log.isWarnEnabled()) {
            double treshold;
            int maxSize = cache.getMaxSize();
            int size = cache.getCacheSize();
            if ((double)size >= (treshold = (double)maxSize * 0.95)) {
                this.log.warn("region " + cache.getName() + " is 95% full, consider extending maxSize");
            }
        }
    }

    public void onRemove(ExoCache cache, Serializable key, Object obj) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Removed entry " + key + " region " + cache.getName());
        }
    }
}

