/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.config;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.Serializable;
import org.exoplatform.services.config.ConfigurationData;
import org.exoplatform.services.config.ConfigurationService;
import org.exoplatform.services.database.HibernateService;

public class ConfigurationServiceImpl
implements ConfigurationService {
    private HibernateService hservice_;
    private XStream xstream_;

    public ConfigurationServiceImpl(HibernateService service) {
        this.hservice_ = service;
        this.xstream_ = new XStream((HierarchicalStreamDriver)new XppDriver());
    }

    public Object getServiceConfiguration(Class serviceType) throws Exception {
        ConfigurationData impl = (ConfigurationData)this.hservice_.findOne(ConfigurationData.class, (Serializable)((Object)serviceType.getName()));
        Object obj = null;
        if (impl == null) {
            obj = this.loadDefaultConfig(serviceType);
            this.saveServiceConfiguration(serviceType, obj);
        } else {
            obj = this.xstream_.fromXML(impl.getData());
        }
        return obj;
    }

    public void saveServiceConfiguration(Class serviceType, Object config) throws Exception {
        ConfigurationData configData = (ConfigurationData)this.hservice_.findOne(ConfigurationData.class, (Serializable)((Object)serviceType.getName()));
        String xml = this.xstream_.toXML(config);
        if (configData == null) {
            configData = new ConfigurationData();
            configData.setServiceType(serviceType.getName());
            configData.setData(xml);
            this.hservice_.create(configData);
        } else {
            configData.setData(xml);
            this.hservice_.update(configData);
        }
    }

    public void removeServiceConfiguration(Class serviceType) throws Exception {
        this.hservice_.remove(serviceType, (Serializable)((Object)serviceType.getName()));
    }

    private Object loadDefaultConfig(Class serviceType) throws Exception {
        return null;
    }
}

