/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;

public class TextClobType
implements UserType {
    private static final Log logger = LogFactory.getLog(TextClobType.class);
    private static final String ORACLE_DRIVER_NAME = "Oracle JDBC driver";
    private static final int ORACLE_DRIVER_MAJOR_VERSION = 9;
    private static final int ORACLE_DRIVER_MINOR_VERSION = 0;

    public int[] sqlTypes() {
        return new int[]{2005};
    }

    public Class returnedClass() {
        return String.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && x.equals(y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void nullSafeSet(PreparedStatement stmt, Object value, int index) throws HibernateException, SQLException {
        PreparedStatement realStatement = this.getRealStatement(stmt);
        DatabaseMetaData dbMetaData = realStatement.getConnection().getMetaData();
        if (value == null) {
            stmt.setNull(index, this.sqlTypes()[0]);
            return;
        } else if (ORACLE_DRIVER_NAME.equals(dbMetaData.getDriverName())) {
            if (dbMetaData.getDriverMajorVersion() < 9 || dbMetaData.getDriverMinorVersion() < 0) throw new HibernateException("No CLOBS support. Use driver version 9, minor 0");
            try {
                Class<?> oracleClobClass = Class.forName("oracle.sql.CLOB");
                Class<?> oracleConnectionClass = Class.forName("oracle.jdbc.OracleConnection");
                Class[] partypes = new Class[]{Connection.class, Boolean.TYPE, Integer.TYPE};
                Method createTemporaryMethod = oracleClobClass.getDeclaredMethod("createTemporary", partypes);
                Field durationSessionField = oracleClobClass.getField("DURATION_SESSION");
                Object[] arglist = new Object[3];
                Connection conn = realStatement.getConnection();
                if (!oracleConnectionClass.isAssignableFrom(conn.getClass())) {
                    throw new HibernateException("JDBC connection object must be a oracle.jdbc.OracleConnection. Connection class is " + conn.getClass().getName());
                }
                arglist[0] = conn;
                arglist[1] = Boolean.TRUE;
                arglist[2] = durationSessionField.get(null);
                Object tempClob = createTemporaryMethod.invoke(null, arglist);
                partypes = new Class[]{Integer.TYPE};
                Method openMethod = oracleClobClass.getDeclaredMethod("open", partypes);
                Field modeReadWriteField = oracleClobClass.getField("MODE_READWRITE");
                arglist = new Object[]{modeReadWriteField.get(null)};
                openMethod.invoke(tempClob, arglist);
                Method getAsciiOutputStreamMethod = oracleClobClass.getDeclaredMethod("getAsciiOutputStream", null);
                OutputStream tempClobOutputStream = (OutputStream)getAsciiOutputStreamMethod.invoke(tempClob, null);
                tempClobOutputStream.write(((String)value).getBytes());
                tempClobOutputStream.flush();
                tempClobOutputStream.close();
                Method closeMethod = oracleClobClass.getDeclaredMethod("close", null);
                closeMethod.invoke(tempClob, null);
                realStatement.setClob(index, (Clob)tempClob);
                return;
            }
            catch (ClassNotFoundException e) {
                throw new HibernateException("Unable to find a required class.\n" + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new HibernateException("Unable to find a required method.\n" + e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new HibernateException("Unable to find a required field.\n" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to access a required method or field.\n" + e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new HibernateException(e.getMessage());
            }
            catch (IOException e) {
                throw new HibernateException(e.getMessage());
            }
        } else {
            String str = (String)value;
            StringReader r = new StringReader(str);
            stmt.setCharacterStream(index, (Reader)r, str.length());
        }
    }

    PreparedStatement getRealStatement(PreparedStatement stmt) throws HibernateException {
        Method[] methods = stmt.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            String returnType = methods[i].getReturnType().getName();
            if (!Statement.class.getName().equals(returnType) && !PreparedStatement.class.getName().equals(returnType) || methods[i].getParameterTypes().length != 0) continue;
            Statement s = null;
            try {
                s = (Statement)methods[i].invoke((Object)stmt, null);
            }
            catch (SecurityException e) {
                throw new HibernateException("Security Error getting method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", e);
            }
            catch (IllegalArgumentException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", e);
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", e);
            }
            catch (InvocationTargetException e) {
                throw new HibernateException("Error calling method [getDelegate] on [" + stmt.getClass().getName() + "::" + methods[i].getName() + "]", e);
            }
            return (PreparedStatement)s;
        }
        return stmt;
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        String stringValue = (String)value;
        return new String(stringValue);
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Reader charReader = rs.getCharacterStream(names[0]);
        if (charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = charReader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading text", ioe);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred closing stream", e);
            }
        }
        return sb.toString();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return new String(value.toString());
    }

    public int hashCode(Object x) throws HibernateException {
        return super.hashCode();
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

