/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;

public class ItemDefinitionData {
    protected final InternalQName name;
    protected final InternalQName declaringNodeType;
    protected final boolean autoCreated;
    protected final boolean mandatory;
    protected final int onParentVersion;
    protected final boolean protectedItem;

    public ItemDefinitionData(InternalQName name, InternalQName declaringNodeType, boolean autoCreated, boolean mandatory, int onParentVersion, boolean protectedItem) {
        this.name = name;
        this.declaringNodeType = declaringNodeType;
        this.autoCreated = autoCreated;
        this.mandatory = mandatory;
        this.onParentVersion = onParentVersion;
        this.protectedItem = protectedItem;
    }

    public boolean isResidualSet() {
        return this.getName().equals(Constants.JCR_ANY_NAME);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ItemDefinitionData test = (ItemDefinitionData)obj;
        return this.name == test.name && this.declaringNodeType == test.declaringNodeType && this.autoCreated == test.autoCreated && this.mandatory == test.mandatory && this.onParentVersion == test.onParentVersion && this.protectedItem == test.protectedItem;
    }

    public InternalQName getName() {
        return this.name;
    }

    public InternalQName getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public boolean isProtected() {
        return this.protectedItem;
    }

    public String toString() {
        return this.name.getAsString();
    }
}

