/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.core.nodetype;

import java.util.Arrays;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;

public class NodeTypeData {
    protected InternalQName name;
    protected InternalQName primaryItemName;
    protected InternalQName[] declaredSupertypeNames;
    protected PropertyDefinitionData[] declaredPropertyDefinitions;
    protected NodeDefinitionData[] declaredChildNodeDefinitions;
    protected boolean hasOrderableChildNodes;
    protected boolean mixin;

    public NodeTypeData(InternalQName name, InternalQName primaryItemName, boolean mixin, boolean hasOrderableChildNodes, InternalQName[] declaredSupertypeNames, PropertyDefinitionData[] declaredPropertyDefinitions, NodeDefinitionData[] declaredChildNodeDefinitions) {
        this.name = name;
        this.primaryItemName = primaryItemName;
        this.mixin = mixin;
        this.hasOrderableChildNodes = hasOrderableChildNodes;
        this.declaredSupertypeNames = declaredSupertypeNames;
        this.declaredPropertyDefinitions = declaredPropertyDefinitions;
        this.declaredChildNodeDefinitions = declaredChildNodeDefinitions;
    }

    public NodeDefinitionData[] getDeclaredChildNodeDefinitions() {
        return this.declaredChildNodeDefinitions;
    }

    public PropertyDefinitionData[] getDeclaredPropertyDefinitions() {
        return this.declaredPropertyDefinitions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.declaredChildNodeDefinitions);
        result = 31 * result + Arrays.hashCode(this.declaredPropertyDefinitions);
        result = 31 * result + Arrays.hashCode(this.declaredSupertypeNames);
        result = 31 * result + (this.hasOrderableChildNodes ? 1231 : 1237);
        result = 31 * result + (this.mixin ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.primaryItemName == null ? 0 : this.primaryItemName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeTypeData other = (NodeTypeData)obj;
        if (!Arrays.equals(this.declaredChildNodeDefinitions, other.declaredChildNodeDefinitions)) {
            return false;
        }
        if (!Arrays.equals(this.declaredPropertyDefinitions, other.declaredPropertyDefinitions)) {
            return false;
        }
        if (!Arrays.equals(this.declaredSupertypeNames, other.declaredSupertypeNames)) {
            return false;
        }
        if (this.hasOrderableChildNodes != other.hasOrderableChildNodes) {
            return false;
        }
        if (this.mixin != other.mixin) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.primaryItemName == null ? other.primaryItemName != null : !this.primaryItemName.equals(other.primaryItemName));
    }

    public InternalQName[] getDeclaredSupertypeNames() {
        return this.declaredSupertypeNames;
    }

    public InternalQName getPrimaryItemName() {
        return this.primaryItemName;
    }

    public InternalQName getName() {
        return this.name;
    }

    public boolean hasOrderableChildNodes() {
        return this.hasOrderableChildNodes;
    }

    public boolean isMixin() {
        return this.mixin;
    }
}

