/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QPathEntry
extends InternalQName
implements Comparable<QPathEntry> {
    private final int index;

    public QPathEntry(InternalQName qName, int index) {
        super(qName.getNamespace(), qName.getName());
        this.index = index > 0 ? index : 1;
    }

    public QPathEntry(String namespace, String name, int index) {
        super(namespace, name);
        this.index = index > 0 ? index : 1;
    }

    public static QPathEntry parse(String qEntry) throws IllegalNameException, NumberFormatException {
        int delimIndex = qEntry.lastIndexOf(":");
        String qnameString = qEntry.substring(0, delimIndex);
        String indexString = qEntry.substring(delimIndex + 1);
        InternalQName qname = InternalQName.parse(qnameString);
        return new QPathEntry(qname, Integer.valueOf(indexString));
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSame(QPathEntry obj) {
        if (super.equals(obj)) {
            return this.index == obj.getIndex();
        }
        return false;
    }

    @Override
    public String getAsString() {
        return this.getAsString(false);
    }

    public String getAsString(boolean showIndex) {
        return super.getAsString() + (showIndex ? ":" + this.index : "");
    }

    @Override
    public int compareTo(QPathEntry compare) {
        int result = 0;
        if (this.isSame(compare)) {
            return result;
        }
        result = this.namespace.compareTo(compare.namespace);
        if (result == 0 && (result = this.name.compareTo(compare.name)) == 0) {
            result = this.index - compare.index;
        }
        return result;
    }

    @Override
    protected String asString() {
        return this.getAsString(true);
    }
}

