/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.observation.ExtendedEventType;
import org.exoplatform.services.log.ExoLogger;

public class AuditAction
implements Action {
    private final Log log = ExoLogger.getLogger("jcr.AuditAction");

    public boolean execute(Context ctx) throws Exception {
        ItemImpl item = (ItemImpl)ctx.get("currentItem");
        int event = (Integer)ctx.get("event");
        NodeImpl node = item.isNode() ? (NodeImpl)item : item.getParent();
        if (node.isNodeType(AuditService.EXO_AUDITABLE)) {
            AuditService auditService = (AuditService)((ExoContainer)ctx.get("exocontainer")).getComponentInstanceOfType(AuditService.class);
            if (!auditService.hasHistory(node)) {
                auditService.createHistory(node);
            }
            auditService.addRecord(item, event);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Record '" + ExtendedEventType.nameFromValue(event) + "' added for " + item.getPath());
            }
            return true;
        }
        return false;
    }
}

