/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.FileDescriptor;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingBinaryFile {
    private static Log log = ExoLogger.getLogger("ext.PendingBinaryFile");
    private HashMap<String, HashMap<String, FileDescriptor>> mapFilePerOwner = new HashMap();
    private long needTransferCounter = 0L;
    private long successfulTransferCounter = 0L;
    private long removedOldChangesLogCounter = 0L;
    private boolean isSuccessfulTransfer = false;
    private boolean isSuccessfulSave = false;

    public void addBinaryFile(String ownerName, String fileName, String systemId) throws IOException {
        HashMap<Object, Object> fileMap;
        File f = File.createTempFile(fileName, "");
        RandomAccessFile binaryFile = new RandomAccessFile(f, "rw");
        FileDescriptor fileDescriptor = new FileDescriptor(f, binaryFile, systemId);
        if (!this.mapFilePerOwner.containsKey(ownerName)) {
            fileMap = new HashMap();
            this.mapFilePerOwner.put(ownerName, fileMap);
        } else {
            fileMap = this.mapFilePerOwner.get(ownerName);
        }
        fileMap.put(fileName, fileDescriptor);
    }

    public RandomAccessFile getRandomAccessFile(String ownName, String fileName) throws Exception {
        HashMap<String, FileDescriptor> fileMap = this.mapFilePerOwner.get(ownName);
        return fileMap.get(fileName).getRandomAccessFile();
    }

    public FileDescriptor getFileDescriptor(String ownName, String fileName) throws IOException {
        if (this.mapFilePerOwner.containsKey(ownName)) {
            HashMap<String, FileDescriptor> fileMap = this.mapFilePerOwner.get(ownName);
            return fileMap.get(fileName);
        }
        this.addBinaryFile(ownName, fileName, "");
        return this.getFileDescriptor(ownName, fileName);
    }

    public List<FileDescriptor> getSortedFilesDescriptorList() {
        ArrayList<FileDescriptor> fileDescriptorhList = new ArrayList<FileDescriptor>();
        for (String ownerName : this.mapFilePerOwner.keySet()) {
            HashMap<String, FileDescriptor> fileMap = this.mapFilePerOwner.get(ownerName);
            fileDescriptorhList.addAll(fileMap.values());
        }
        if (log.isDebugEnabled()) {
            log.debug("getSortedFilePath() : " + fileDescriptorhList.size());
        }
        Collections.sort(fileDescriptorhList);
        if (log.isDebugEnabled()) {
            log.debug("\n\nList has been sorted :\n");
            for (FileDescriptor fd : fileDescriptorhList) {
                log.debug(fd.getFile().getAbsolutePath());
            }
        }
        return fileDescriptorhList;
    }

    public List<String> getFileNameList() {
        ArrayList<String> list = new ArrayList<String>();
        for (String ownerName : this.mapFilePerOwner.keySet()) {
            HashMap<String, FileDescriptor> fileMap = this.mapFilePerOwner.get(ownerName);
            for (String fileName : fileMap.keySet()) {
                list.add(fileName);
            }
        }
        return list;
    }

    public long getNeedTransferCounter() {
        return this.needTransferCounter;
    }

    public void setNeedTransferCounter(long needTransferCounter) {
        this.needTransferCounter = needTransferCounter;
    }

    public long getRemovedOldChangesLogCounter() {
        return this.removedOldChangesLogCounter;
    }

    public void setRemovedOldChangesLogCounter(long needRemoveOldChangesLogCounter) {
        this.removedOldChangesLogCounter = needRemoveOldChangesLogCounter;
    }

    public boolean isAllOldChangesLogsRemoved() {
        return this.needTransferCounter == this.removedOldChangesLogCounter;
    }

    public long getSuccessfulTransferCounter() {
        return this.successfulTransferCounter;
    }

    public void setSuccessfulTransferCounter(long successfulTransferCounter) {
        this.successfulTransferCounter = successfulTransferCounter;
    }

    public boolean isSuccessfulTransfer() {
        return this.isSuccessfulTransfer;
    }

    public void addToSuccessfulTransferCounter(long count) {
        this.successfulTransferCounter += count;
        this.isSuccessfulTransfer = this.needTransferCounter == this.successfulTransferCounter;
    }

    public boolean isSuccessfulSave() {
        return this.isSuccessfulSave;
    }

    public void setSuccessfulSave(boolean successfulSave) {
        this.isSuccessfulSave = successfulSave;
    }
}

