/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.replication.async.OnSynchronizationWorkspaceListenersFilter;
import org.exoplatform.services.jcr.ext.replication.async.WorkspaceSynchronizer;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ReplicableValueData;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.ext.replication.async.storage.SynchronizationException;
import org.exoplatform.services.jcr.ext.replication.async.storage.SynchronizerChangesLog;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceSynchronizerImpl
implements WorkspaceSynchronizer {
    private static final Log LOG = ExoLogger.getLogger("ext.WorkspaceSynchronizerImpl");
    protected final LocalStorage storage;
    protected final PersistentDataManager workspace;
    protected final PersistentDataManager systemWorkspace;
    protected final File tempDirectory;
    protected final int maxBufferSize;
    protected final WorkspaceFileCleanerHolder cleanerHolder;

    public WorkspaceSynchronizerImpl(PersistentDataManager workspace, PersistentDataManager systemWorkspace, LocalStorage storage, WorkspaceEntry workspaceConfig, WorkspaceFileCleanerHolder cleanerHolder) {
        this.storage = storage;
        this.workspace = workspace;
        this.systemWorkspace = systemWorkspace;
        this.maxBufferSize = workspaceConfig.getContainer().getParameterInteger("max-buffer-size", 204800);
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        this.cleanerHolder = cleanerHolder;
    }

    @Override
    public ChangesStorage<ItemState> getLocalChanges() throws IOException {
        return this.storage.getLocalChanges();
    }

    @Override
    public void save(ChangesStorage<ItemState> synchronizedChanges) throws SynchronizationException, InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        OnSynchronizationWorkspaceListenersFilter apiFilter = new OnSynchronizationWorkspaceListenersFilter();
        this.workspace.addItemPersistenceListenerFilter(apiFilter);
        this.systemWorkspace.addItemPersistenceListenerFilter(apiFilter);
        try {
            try {
                this.saveChangesLog(synchronizedChanges);
            }
            catch (ClassCastException e) {
                throw new SynchronizationException("Error of merge result save " + e, e);
            }
            catch (IOException e) {
                throw new SynchronizationException("Error of merge result save " + e, e);
            }
            catch (ClassNotFoundException e) {
                throw new SynchronizationException("Error of merge result save " + e, e);
            }
            catch (Throwable e) {
                throw new SynchronizationException("Error of merge result save " + e, e);
            }
        }
        catch (StorageRuntimeException e) {
            throw new SynchronizationException("Error of merge result read on save " + e, e);
        }
        finally {
            this.workspace.removeItemPersistenceListenerFilter(apiFilter);
            this.systemWorkspace.removeItemPersistenceListenerFilter(apiFilter);
        }
    }

    private void saveChangesLog(ChangesStorage<ItemState> changes) throws IOException, ClassCastException, IllegalStateException, ClassNotFoundException, InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        ArrayList<ItemState> sysStates = new ArrayList<ItemState>();
        Iterator<ItemState> iter = changes.getChanges();
        while (iter.hasNext()) {
            ItemState state = iter.next();
            if (state.isNode()) {
                if (this.isSystemDescendant(state.getData().getQPath())) {
                    sysStates.add(state);
                    continue;
                }
                states.add(state);
                continue;
            }
            TransientPropertyData prop = (TransientPropertyData)state.getData();
            ArrayList<ValueData> nVals = new ArrayList<ValueData>();
            for (ValueData vd : prop.getValues()) {
                if (vd.isByteArray()) {
                    nVals.add(vd);
                    continue;
                }
                ReplicableValueData rvd = (ReplicableValueData)vd;
                nVals.add(new TransientValueData(vd.getOrderNumber(), null, null, rvd.getSpoolFile(), this.cleanerHolder.getFileCleaner(), this.maxBufferSize, this.tempDirectory, true));
                rvd.getSpoolFile().release(rvd);
            }
            TransientPropertyData nProp = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
            nProp.setValues(nVals);
            ItemState newState = new ItemState(nProp, state.getState(), state.isEventFire(), state.getAncestorToSave(), state.isInternallyCreated(), state.isPersisted());
            if (this.isSystemDescendant(state.getData().getQPath())) {
                sysStates.add(newState);
                continue;
            }
            states.add(newState);
        }
        this.systemWorkspace.save(new SynchronizerChangesLog(new PlainChangesLogImpl(sysStates, IdGenerator.generate())));
        this.workspace.save(new SynchronizerChangesLog(new PlainChangesLogImpl(states, IdGenerator.generate())));
    }

    private boolean isSystemDescendant(QPath path) {
        return path.isDescendantOf(Constants.JCR_SYSTEM_PATH) || path.equals(Constants.JCR_SYSTEM_PATH);
    }
}

