/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.merge;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.merge.AbstractMerger;
import org.exoplatform.services.jcr.ext.replication.async.storage.BufferedItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.CompositeItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMerger
extends AbstractMerger {
    public AddMerger(boolean localPriority, RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, ResourcesHolder resHolder) {
        super(localPriority, exporter, dataManager, ntManager, resHolder);
    }

    @Override
    public EditableChangesStorage<ItemState> merge(ItemState itemChange, ChangesStorage<ItemState> income, ChangesStorage<ItemState> local, String mergeTempDir, List<QPath> skippedList, List<QPath> restoredOrder) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, StorageRuntimeException {
        boolean itemChangeProcessed = false;
        ItemState incomeState = itemChange;
        CompositeItemStatesStorage<ItemState> resultState = new CompositeItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
        ArrayList<QPath> locSkippedList = new ArrayList<QPath>();
        Iterator<ItemState> liter = local.getChanges();
        block12: while (liter.hasNext()) {
            ItemState localState = liter.next();
            ItemData incomeData = incomeState.getData();
            ItemData localData = localState.getData();
            for (QPath skipPath : locSkippedList) {
                if (!localData.getQPath().equals(skipPath)) continue;
                continue block12;
            }
            if (!localData.isNode() && (localData.getQPath().getName().equals(Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals(Constants.JCR_LOCKOWNER))) continue;
            if (this.isLocalPriority()) {
                switch (localState.getState()) {
                    case 1: {
                        String parentIdentifier;
                        InternalQName propertyName;
                        if (localData.isNode()) {
                            if (incomeData.isNode()) {
                                if (!incomeData.getQPath().equals(localData.getQPath())) break;
                                this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                            if (!incomeData.getQPath().equals(localData.getQPath())) break;
                            propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                            if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (incomeData.isNode()) {
                            if (!incomeData.getQPath().equals(localData.getQPath())) break;
                            propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                            if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier()))) continue block12;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (!incomeData.getQPath().equals(localData.getQPath())) break;
                        this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                        return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                    }
                    case 4: {
                        ItemState nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            List<ItemState> updateSeq = local.getUpdateSequence(localState);
                            for (ItemState item : updateSeq) {
                                if (!incomeData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            if (!localData.isNode()) break;
                            if (incomeData.isNode()) {
                                if (!incomeData.getQPath().isDescendantOf(localData.getQPath()) && !incomeData.getQPath().equals(nextLocalState.getData().getQPath())) break;
                                this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                            if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (!localData.isNode()) break;
                        if (incomeData.isNode()) {
                            if (!incomeData.getQPath().isDescendantOf(localData.getQPath()) && !incomeData.getQPath().equals(localData.getQPath())) break;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (!incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                        this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                        return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                    }
                    case 2: {
                        break;
                    }
                    case 32: {
                        break;
                    }
                }
                continue;
            }
            switch (localState.getState()) {
                case 1: {
                    ItemState nextState = local.findNextState(localState, localData.getIdentifier(), localData.getQPath(), 4);
                    if (nextState != null && nextState.isPersisted()) break;
                    if (localData.isNode()) {
                        if (!incomeData.isNode() || !incomeData.getQPath().equals(localData.getQPath())) break;
                        if (incomeData.isNode() != localData.isNode()) {
                            String parentIdentifier;
                            InternalQName propertyName = !incomeData.isNode() ? incomeData.getQPath().getName() : localData.getQPath().getName();
                            String string = parentIdentifier = !incomeData.isNode() ? incomeData.getParentIdentifier() : localData.getParentIdentifier();
                            if (this.isPropertyAllowed(propertyName, (NodeData)this.dataManager.getItemData(parentIdentifier))) break;
                        }
                        List<ItemState> items = local.getUniqueTreeChanges(localState, localData.getQPath());
                        for (int i = items.size() - 1; i >= 0; --i) {
                            ItemState item;
                            if (local.findLastState(items.get(i).getData().getQPath()) == 4) continue;
                            if (items.get(i).getData().isNode()) {
                                for (ItemState st : this.generateDeleleLockProperties((NodeData)items.get(i).getData())) {
                                    resultState.add(st);
                                }
                            }
                            resultState.add(new ItemState(items.get(i).getData(), 4, items.get(i).isEventFire(), items.get(i).getData().getQPath()));
                            if (items.get(i).getState() != 32 || i != 0 && items.get(i - 1).getState() == 32) continue;
                            for (int j = i; j < items.size() && items.get(j).getState() == 32 && !(item = local.findPrevState(items.get(j), items.get(j).getData().getIdentifier())).getData().getQPath().makeParentPath().equals(items.get(j).getData().getQPath().makeParentPath()); ++j) {
                                resultState.add(this.generateRestoreRenamedItem(item, items.get(j)));
                            }
                        }
                        for (ItemState st : income.getTreeChanges(incomeState, incomeData.getQPath())) {
                            if (st.getData().isNode() && st.getState() == 4) {
                                for (ItemState inSt : this.generateDeleleLockProperties((NodeData)st.getData())) {
                                    resultState.add(inSt);
                                }
                            }
                            resultState.add(st);
                        }
                        return resultState;
                    }
                    if (incomeData.isNode() || !incomeData.getQPath().equals(localData.getQPath())) break;
                    resultState.add(new ItemState(localData, 4, localState.isEventFire(), localData.getQPath()));
                    break;
                }
                case 4: {
                    ItemState nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        List<ItemState> updateSeq = local.getUpdateSequence(localState);
                        for (ItemState st : updateSeq) {
                            if (!incomeData.getQPath().isDescendantOf(st.getData().getQPath()) || this.isOrderRestored(restoredOrder, localData.getQPath().makeParentPath())) continue;
                            restoredOrder.add(localData.getQPath().makeParentPath());
                            for (ItemState inSt : this.generateRestoreOrder(localState, local)) {
                                resultState.add(inSt);
                            }
                        }
                        continue block12;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        QPath nextLocNodePath;
                        QPath incNodePath = incomeData.isNode() ? incomeData.getQPath() : incomeData.getQPath().makeParentPath();
                        QPath locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                        QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                        if (!incomeData.getQPath().isDescendantOf(locNodePath) && !incomeData.getQPath().equals(locNodePath) && !incomeData.getQPath().isDescendantOf(nextLocNodePath) && !incomeData.getQPath().equals(nextLocNodePath) && !nextLocNodePath.isDescendantOf(incomeData.getQPath()) && !nextLocNodePath.equals(incomeData.getQPath())) break;
                        List<ItemState> items = local.getRenameSequence(localState);
                        for (int i = items.size() - 1; i >= 0; --i) {
                            ItemState item = items.get(i);
                            locSkippedList.add(item.getData().getQPath());
                            if (item.getState() == 32) {
                                if (item.getData().isNode()) {
                                    for (ItemState st : this.generateDeleleLockProperties((NodeData)item.getData())) {
                                        resultState.add(st);
                                    }
                                }
                                resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath()));
                                continue;
                            }
                            if (item.getState() != 4 || incNodePath.equals(locNodePath)) continue;
                            resultState.add(this.generateRestoreRenamedItem(item, items.get(items.size() - i - 1)));
                        }
                        for (ItemState st : income.getTreeChanges(incomeState, incomeData.isNode() ? incomeData.getQPath() : incomeData.getQPath().makeParentPath())) {
                            resultState.add(st);
                        }
                        return resultState;
                    }
                    if (income.findNextState(incomeState, incomeData.getQPath(), 1) != null || local.findNextState(localState, localData.getParentIdentifier(), localData.getQPath().makeParentPath(), 4) != null || !localData.isNode() || !incomeData.isNode() || !incomeData.getQPath().isDescendantOf(localData.getQPath())) break;
                    this.accumulateSkippedList(incomeState, localData.getQPath(), income, skippedList);
                    resultState.addAll(this.exporter.exportItem(localData.getIdentifier()));
                    return resultState;
                }
                case 2: {
                    break;
                }
                case 32: {
                    break;
                }
            }
        }
        if (!itemChangeProcessed) {
            resultState.add(incomeState);
        }
        return resultState;
    }
}

