/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.merge;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.merge.AbstractMerger;
import org.exoplatform.services.jcr.ext.replication.async.storage.BufferedItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.CompositeItemStatesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateMerger
extends AbstractMerger {
    public UpdateMerger(boolean localPriority, RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, ResourcesHolder resHolder) {
        super(localPriority, exporter, dataManager, ntManager, resHolder);
    }

    @Override
    public EditableChangesStorage<ItemState> merge(ItemState itemChange, ChangesStorage<ItemState> income, ChangesStorage<ItemState> local, String mergeTempDir, List<QPath> skippedList, List<QPath> restoredOrder) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, StorageRuntimeException {
        boolean itemChangeProcessed = false;
        ItemState incomeState = itemChange;
        ItemState nextIncomeState = null;
        CompositeItemStatesStorage<ItemState> resultState = new CompositeItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
        List<ItemState> incUpdateSeq = income.getUpdateSequence(incomeState);
        if (incomeState.getData().isNode()) {
            for (ItemState st : incUpdateSeq) {
                if (st.getState() != 2 || !st.getData().getIdentifier().equals(incomeState.getData().getIdentifier())) continue;
                nextIncomeState = st;
                break;
            }
        }
        Iterator<ItemState> liter = local.getChanges();
        block15: while (liter.hasNext()) {
            List<ItemState> locUpdateSeq;
            QPath nextLocNodePath;
            QPath locNodePath;
            ItemState nextLocalState;
            ItemState localState = liter.next();
            ItemData incomeData = incomeState.getData();
            ItemData localData = localState.getData();
            if (!localData.isNode() && (localData.getQPath().getName().equals(Constants.JCR_LOCKISDEEP) || localData.getQPath().getName().equals(Constants.JCR_LOCKOWNER))) continue;
            if (this.isLocalPriority()) {
                switch (localState.getState()) {
                    case 1: {
                        for (ItemState st : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(st.getData().getQPath())) continue;
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        continue block15;
                    }
                    case 4: {
                        nextLocalState = local.findNextState(localState, localData.getIdentifier());
                        if (nextLocalState != null && nextLocalState.getState() == 32) {
                            locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                            QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                            if (incomeData.isNode()) {
                                for (ItemState item : incUpdateSeq) {
                                    if (!item.getData().getQPath().isDescendantOf(locNodePath) && !item.getData().getQPath().equals(locNodePath) && !locNodePath.isDescendantOf(item.getData().getQPath()) && !nextLocNodePath.isDescendantOf(item.getData().getQPath())) continue;
                                    return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                                }
                                continue block15;
                            }
                            if (!incomeData.getQPath().isDescendantOf(locNodePath)) break;
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        if (nextLocalState != null && nextLocalState.getState() == 2) {
                            locUpdateSeq = local.getUpdateSequence(localState);
                            for (ItemState locSt : locUpdateSeq) {
                                for (ItemState incSt : incUpdateSeq) {
                                    if (!locSt.getData().getQPath().isDescendantOf(incSt.getData().getQPath()) && !locSt.getData().getQPath().equals(incSt.getData().getQPath()) && !incSt.getData().getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                                    return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                                }
                            }
                            continue block15;
                        }
                        ItemState locParentNodeState = local.findNextState(localState, localData.getParentIdentifier(), localData.getQPath().makeParentPath(), 4);
                        if (localData.isNode() || locParentNodeState != null) {
                            QPath locNodePath2 = localData.isNode() ? localData.getQPath() : locParentNodeState.getData().getQPath();
                            for (ItemState item : incUpdateSeq) {
                                if (!item.getData().getQPath().isDescendantOf(locNodePath2) && !item.getData().getQPath().equals(locNodePath2) && !locNodePath2.isDescendantOf(item.getData().getQPath())) continue;
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                            continue block15;
                        }
                        if (incomeData.isNode()) {
                            for (ItemState item : incUpdateSeq) {
                                if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                                return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                            }
                            continue block15;
                        }
                        if (!incomeData.getQPath().equals(localData.getQPath())) break;
                        return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                    }
                    case 2: {
                        if (localData.isNode()) break;
                        if (!incomeData.isNode()) {
                            if (!incomeData.getQPath().equals(localData.getQPath())) break;
                            this.accumulateSkippedList(incomeState, incomeData.getQPath(), income, skippedList);
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        for (ItemState item : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        continue block15;
                    }
                    case 32: {
                        break;
                    }
                    case 16: {
                        for (ItemState st : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(st.getData().getQPath()) && !localData.getQPath().equals(st.getData().getQPath())) continue;
                            return new BufferedItemStatesStorage<ItemState>(new File(mergeTempDir), null, this.resHolder);
                        }
                        break;
                    }
                }
                continue;
            }
            block7 : switch (localState.getState()) {
                case 1: {
                    for (ItemState st : incUpdateSeq) {
                        if (st.getState() == 4 || !localData.getQPath().isDescendantOf(st.getData().getQPath())) continue;
                        List<ItemState> items = local.getChanges(localState, localData.getQPath(), true);
                        for (int i = items.size() - 1; i >= 0; --i) {
                            if (local.findLastState(items.get(i).getData().getQPath()) == 4) continue;
                            if (items.get(i).getData().isNode()) {
                                for (ItemState inSt : this.generateDeleleLockProperties((NodeData)items.get(i).getData())) {
                                    resultState.add(inSt);
                                }
                            }
                            resultState.add(new ItemState(items.get(i).getData(), 4, items.get(i).isEventFire(), items.get(i).getData().getQPath()));
                        }
                        for (ItemState inSt : incUpdateSeq) {
                            resultState.add(inSt);
                        }
                        return resultState;
                    }
                    continue block15;
                }
                case 4: {
                    Iterator<ItemState> exportedList;
                    nextLocalState = local.findNextState(localState, localData.getIdentifier());
                    if (nextLocalState != null && nextLocalState.getState() == 2) {
                        locUpdateSeq = local.getUpdateSequence(localState);
                        for (ItemState locSt : locUpdateSeq) {
                            for (ItemState incSt : incUpdateSeq) {
                                if (!locSt.getData().getQPath().isDescendantOf(incSt.getData().getQPath()) && !locSt.getData().getQPath().equals(incSt.getData().getQPath()) && !incSt.getData().getQPath().isDescendantOf(locSt.getData().getQPath())) continue;
                                if (this.isOrderRestored(restoredOrder, localData.getQPath().makeParentPath())) break block7;
                                restoredOrder.add(localData.getQPath().makeParentPath());
                                for (ItemState inSt : this.generateRestoreOrder(localState, local)) {
                                    resultState.add(inSt);
                                }
                                continue block15;
                            }
                        }
                        continue block15;
                    }
                    if (nextLocalState != null && nextLocalState.getState() == 32) {
                        locNodePath = localData.isNode() ? localData.getQPath() : localData.getQPath().makeParentPath();
                        QPath qPath = nextLocNodePath = localData.isNode() ? nextLocalState.getData().getQPath() : nextLocalState.getData().getQPath().makeParentPath();
                        if (incomeData.isNode()) {
                            for (ItemState st : incUpdateSeq) {
                                if (!st.getData().getQPath().isDescendantOf(locNodePath) && !st.getData().getQPath().equals(locNodePath) && !locNodePath.isDescendantOf(st.getData().getQPath()) && !nextLocNodePath.isDescendantOf(st.getData().getQPath())) continue;
                                List<ItemState> rename = local.getRenameSequence(localState);
                                for (int i = rename.size() - 1; i >= 0; --i) {
                                    ItemState item = rename.get(i);
                                    if (item.getState() == 32) {
                                        if (item.getData().isNode()) {
                                            for (ItemState inSt : this.generateDeleleLockProperties((NodeData)item.getData())) {
                                                resultState.add(inSt);
                                            }
                                        }
                                        resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath()));
                                        continue;
                                    }
                                    if (item.getState() != 4) continue;
                                    resultState.add(this.generateRestoreRenamedItem(item, rename.get(rename.size() - i - 1)));
                                }
                                for (ItemState inSt : incUpdateSeq) {
                                    resultState.add(inSt);
                                }
                                return resultState;
                            }
                            continue block15;
                        }
                        if (!incomeData.getQPath().isDescendantOf(locNodePath) || this.isNodeRenamed(restoredOrder, locNodePath)) break;
                        List<ItemState> rename = local.getRenameSequence(localState);
                        for (int i = rename.size() - 1; i >= 0; --i) {
                            ItemState item = rename.get(i);
                            if (item.getState() == 32) {
                                if (item.getData().isNode()) {
                                    for (ItemState inSt : this.generateDeleleLockProperties((NodeData)item.getData())) {
                                        resultState.add(inSt);
                                    }
                                }
                                resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath()));
                                continue;
                            }
                            if (item.getState() != 4) continue;
                            resultState.add(this.generateRestoreRenamedItem(item, rename.get(rename.size() - i - 1)));
                        }
                        restoredOrder.add(rename.get(rename.size() / 2 - 1).getData().getQPath());
                        break;
                    }
                    if (local.findNextState(localState, localData.getParentIdentifier(), localData.getQPath().makeParentPath(), 4) != null) break;
                    if (localData.isNode()) {
                        for (ItemState item : incUpdateSeq) {
                            if (item.getData().getQPath().equals(localData.getQPath()) || localData.getQPath().isDescendantOf(item.getData().getQPath())) {
                                resultState.addAll(this.exporter.exportItem(localData.getIdentifier()));
                                for (ItemState st : incUpdateSeq) {
                                    resultState.add(st);
                                }
                                return resultState;
                            }
                            if (!item.getData().getQPath().isDescendantOf(localData.getQPath())) continue;
                            resultState.addAll(this.exporter.exportItem(localData.getIdentifier()));
                            return resultState;
                        }
                        continue block15;
                    }
                    if (incomeData.isNode()) {
                        block39: for (ItemState item : incUpdateSeq) {
                            if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                            exportedList = this.exporter.exportItem(localData.getParentIdentifier()).getChanges();
                            while (exportedList.hasNext()) {
                                ItemState st = exportedList.next();
                                if (st.getData().isNode() || !st.getData().getQPath().equals(localData.getQPath())) continue;
                                resultState.add(new ItemState(st.getData(), 1, st.isEventFire(), st.getData().getQPath()));
                                continue block39;
                            }
                        }
                        continue block15;
                    }
                    if (!localData.getQPath().equals(incomeData.getQPath())) break;
                    resultState.add(new ItemState(incomeData, 1, incomeState.isEventFire(), incomeData.getQPath()));
                    itemChangeProcessed = true;
                    break;
                }
                case 2: {
                    Iterator<ItemState> exportedList;
                    if (localData.isNode() || !incomeData.isNode()) break;
                    for (ItemState item : incUpdateSeq) {
                        if (!localData.getQPath().isDescendantOf(item.getData().getQPath())) continue;
                        exportedList = this.exporter.exportItem(localData.getParentIdentifier()).getChanges();
                        while (exportedList.hasNext()) {
                            ItemState st = exportedList.next();
                            if (st.getData().isNode() || !st.getData().getQPath().equals(localData.getQPath())) continue;
                            resultState.add(new ItemState(st.getData(), 2, st.isEventFire(), st.getData().getQPath()));
                            break block7;
                        }
                    }
                    continue block15;
                }
                case 32: {
                    break;
                }
                case 16: {
                    for (ItemState st : incUpdateSeq) {
                        if (!localData.getQPath().isDescendantOf(st.getData().getQPath()) && !localData.getQPath().equals(st.getData().getQPath())) continue;
                        for (ItemState item : this.generateRestoreMixinChanges(localState, local)) {
                            resultState.add(item);
                        }
                    }
                    break;
                }
            }
        }
        if (!itemChangeProcessed) {
            if (nextIncomeState != null) {
                if (incomeState.getData().isNode()) {
                    for (ItemState st : incUpdateSeq) {
                        resultState.add(st);
                    }
                }
            } else {
                resultState.add(incomeState);
            }
        }
        return resultState;
    }
}

