/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesFile;
import org.exoplatform.services.jcr.ext.replication.async.storage.InvalidChecksumException;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.log.ExoLogger;

public class RandomChangesFile
implements ChangesFile {
    protected static final Log LOG = ExoLogger.getLogger("ext.RandomChangesFile");
    private final byte[] crc;
    private byte[] crcCalc = null;
    private final long id;
    private final File file;
    private final ResourcesHolder resHolder;
    private RandomAccessFile fileAccessor;
    private MessageDigest digest;

    public RandomChangesFile(File file, byte[] crc, long id, ResourcesHolder resHolder) throws NoSuchAlgorithmException {
        this.crc = crc;
        this.id = id;
        this.file = file;
        this.resHolder = resHolder;
        this.digest = MessageDigest.getInstance("MD5");
    }

    public byte[] getChecksum() {
        return this.crc;
    }

    public InputStream getInputStream() throws IOException {
        this.finishWrite();
        FileInputStream in = new FileInputStream(this.file);
        this.resHolder.add(in);
        return in;
    }

    @Deprecated
    public OutputStream getOutputStream() throws IOException {
        return new OutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(int b) throws IOException {
                RandomChangesFile.this.checkFileAccessor();
                RandomAccessFile randomAccessFile = RandomChangesFile.this.fileAccessor;
                synchronized (randomAccessFile) {
                    RandomChangesFile.this.fileAccessor.write(b);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] b) throws IOException {
                RandomChangesFile.this.checkFileAccessor();
                RandomAccessFile randomAccessFile = RandomChangesFile.this.fileAccessor;
                synchronized (randomAccessFile) {
                    RandomChangesFile.this.fileAccessor.write(b);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] b, int off, int len) throws IOException {
                RandomChangesFile.this.checkFileAccessor();
                RandomAccessFile randomAccessFile = RandomChangesFile.this.fileAccessor;
                synchronized (randomAccessFile) {
                    RandomChangesFile.this.fileAccessor.write(b, off, len);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(byte[] data, long position) throws IOException {
        this.checkFileAccessor();
        RandomAccessFile randomAccessFile = this.fileAccessor;
        synchronized (randomAccessFile) {
            this.fileAccessor.seek(position);
            this.fileAccessor.write(data);
            this.digest.update(data);
        }
    }

    public void finishWrite() throws IOException {
        if (this.fileAccessor != null) {
            this.fileAccessor.close();
            this.fileAccessor = null;
            this.crcCalc = this.digest.digest();
            this.digest = null;
        }
    }

    private void checkFileAccessor() throws IOException {
        if (this.fileAccessor == null) {
            this.fileAccessor = new RandomAccessFile(this.file, "rwd");
            this.resHolder.add(this.fileAccessor);
            this.fileAccessor.seek(this.file.length());
        }
    }

    public boolean delete() throws IOException {
        this.finishWrite();
        return this.file.delete();
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }

    public long getLength() {
        return this.file.length();
    }

    public void validate() throws InvalidChecksumException {
        if (this.crc == null || this.crc.length == 0) {
            throw new InvalidChecksumException("File checksum is null or empty.");
        }
        if (!Arrays.equals(this.crc, this.crcCalc)) {
            throw new InvalidChecksumException("File content isn't match checksum.");
        }
    }
}

