/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.storage;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.log.ExoLogger;

public class ReplicableValueData
extends AbstractValueData
implements Externalizable {
    protected static final Log LOG = ExoLogger.getLogger("jcr.LocalStorageImpl");
    public static final String FILE_PREFIX = "jcrrvd";
    private static final int DEF_MAX_BUF_SIZE = 20480;
    protected static final ThreadLocal<Boolean> readBlobData = new ThreadLocal();
    protected static FileCleaner serviceCleaner;
    private final FileCleaner cleaner;
    private SpoolFile spoolFile;
    private boolean localFile = false;

    public static void initFileCleaner(FileCleaner cleaner) {
        serviceCleaner = cleaner;
    }

    public static void setReadBlobData(boolean flag) {
        readBlobData.set(flag);
    }

    public ReplicableValueData() {
        super(0);
        this.cleaner = serviceCleaner;
    }

    public ReplicableValueData(SpoolFile file, int orderNumber, FileCleaner cleaner) throws IOException {
        super(orderNumber);
        this.spoolFile = file;
        this.cleaner = cleaner;
        this.spoolFile.acquire(this);
    }

    public SpoolFile getSpoolFile() {
        return this.spoolFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        out.writeBoolean(this.localFile);
        if (this.localFile) {
            byte[] cpath = this.spoolFile.getCanonicalPath().getBytes("UTF-8");
            out.writeLong(cpath.length);
            out.write(cpath);
        } else {
            long length = this.spoolFile.length();
            out.writeLong(length);
            FileInputStream in = new FileInputStream(this.spoolFile);
            try {
                byte[] buf = new byte[length > 20480L ? 20480 : (int)length];
                int l = 0;
                while ((l = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, l);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long length;
        this.orderNumber = in.readInt();
        this.localFile = in.readBoolean();
        if (this.localFile) {
            byte[] cpath = new byte[(int)length];
            in.readFully(cpath);
            SpoolFile sf = new SpoolFile(new String(cpath, "UTF-8"));
            sf.acquire(this);
            this.spoolFile = sf;
        } else {
            SpoolFile sf = new SpoolFile(File.createTempFile(FILE_PREFIX, null).getAbsolutePath());
            FileOutputStream sfout = new FileOutputStream(sf);
            try {
                byte[] buff = new byte[20480];
                sf.acquire(this);
                for (length = in.readLong(); length >= 20480L; length -= 20480L) {
                    in.readFully(buff);
                    sfout.write(buff);
                }
                if (length > 0L) {
                    buff = new byte[(int)length];
                    in.readFully(buff);
                    sfout.write(buff);
                }
            }
            finally {
                sfout.close();
            }
            this.spoolFile = sf;
            this.localFile = true;
        }
    }

    public byte[] getAsByteArray() throws IOException {
        throw new IOException("This is Stream data.");
    }

    public InputStream getAsStream() throws IOException {
        if (this.spoolFile.exists()) {
            return new FileInputStream(this.spoolFile);
        }
        throw new IOException("Empty Stream data. Check readBlobData value.");
    }

    public long getLength() {
        return this.spoolFile.length();
    }

    public boolean isByteArray() {
        return false;
    }

    public TransientValueData createTransientCopy() throws RepositoryException {
        throw new RepositoryException("Not supported");
    }

    protected void finalize() throws Throwable {
        if (this.spoolFile != null && !this.spoolFile.inUse() && this.spoolFile.exists() && !this.spoolFile.delete()) {
            if (this.cleaner != null) {
                log.info("Could not remove file. Add to fileCleaner " + this.spoolFile);
                this.cleaner.addFile(this.spoolFile);
            } else {
                log.warn("Could not remove temporary file on finalize " + this.spoolFile.getAbsolutePath());
            }
        }
    }
}

