/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.transport;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;

public class SimpleChat
extends ReceiverAdapter {
    JChannel channel;
    final String userName;
    final String config;

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            String config = null;
            if (args[0].startsWith("-config")) {
                config = args[0].split("=")[1];
                System.out.println("use config " + config);
            }
            if (args.length > 1 && args[1].startsWith("-user")) {
                String user = args[1].split("=")[1];
                System.out.println("use username " + user);
                new SimpleChat(user, config).start();
            } else {
                System.out.println("user name expected, try java.... -user=exo");
            }
        } else {
            System.out.println("user name expected, try java.... -user=exo");
        }
    }

    SimpleChat(String userName, String config) {
        this.userName = userName;
        this.config = config;
    }

    public void viewAccepted(View new_view) {
        System.out.println(this.userName + " ** view: " + new_view);
    }

    public void receive(Message msg) {
        System.out.println(this.userName + " " + msg.getSrc() + ": " + msg.getObject());
    }

    private void start() throws Exception {
        this.channel = this.config != null ? new JChannel(this.config) : new JChannel();
        this.channel.setReceiver((Receiver)this);
        this.channel.connect("ChatCluster");
        this.eventLoop();
        this.channel.close();
    }

    private void eventLoop() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        block2: while (true) {
            try {
                while (true) {
                    System.out.print(this.userName + "> ");
                    System.out.flush();
                    String line = in.readLine().toLowerCase();
                    if (line.startsWith("quit") || line.startsWith("exit")) break block2;
                    line = "[" + this.userName + "] " + line;
                    Message msg = new Message(null, null, (Serializable)((Object)line));
                    this.channel.send(msg);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

