/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.priority;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.Packet;
import org.exoplatform.services.jcr.ext.replication.PacketListener;
import org.exoplatform.services.jcr.ext.replication.priority.MemberListener;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPriorityChecker
implements PacketListener {
    public static final int MAX_PRIORITY = 100;
    private static Log log = ExoLogger.getLogger("ext.AbstractPriorityChecker");
    protected final ChannelManager channelManager;
    protected final int ownPriority;
    protected final String ownName;
    protected final List<String> otherParticipants;
    protected HashMap<String, Integer> currentParticipants;
    protected String identifier;
    protected MemberListener memberListener;

    public AbstractPriorityChecker(ChannelManager channelManager, int ownPriority, String ownName, List<String> otherParticipants) {
        this.ownPriority = ownPriority;
        this.ownName = ownName;
        this.otherParticipants = new ArrayList<String>(otherParticipants);
        this.channelManager = channelManager;
        this.channelManager.addPacketListener(this);
        this.currentParticipants = new HashMap();
    }

    @Override
    public abstract void receive(Packet var1);

    public void informAll() {
        try {
            this.identifier = IdGenerator.generate();
            this.currentParticipants = new HashMap();
            Packet pktInformer = new Packet(30, this.ownName, this.ownPriority, this.identifier);
            this.channelManager.sendPacket(pktInformer);
        }
        catch (Exception e) {
            log.error("Can not informed the other participants", e);
        }
    }

    protected void printOnlineMembers() {
        log.info(this.channelManager.getChannel().getClusterName() + " : " + this.identifier + " :");
        for (String memberName : this.currentParticipants.keySet()) {
            log.debug("    " + memberName + ":" + this.currentParticipants.get(memberName));
        }
    }

    public void setMemberListener(MemberListener memberListener) {
        this.memberListener = memberListener;
    }

    public abstract boolean isMaxPriority();

    public boolean isMaxOnline() {
        if (this.ownPriority == 100) {
            return true;
        }
        for (String nodeName : this.currentParticipants.keySet()) {
            if (this.currentParticipants.get(nodeName) != 100) continue;
            return true;
        }
        return false;
    }

    public boolean isAllOnline() {
        return this.otherParticipants.size() == this.currentParticipants.size();
    }
}

