/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.recovery.PendingConfirmationChengesLog;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.log.ExoLogger;

public class WaitConfirmation
extends Thread {
    private static Log log = ExoLogger.getLogger("ext.WaitConfirmation");
    private long timeOut;
    private RecoveryManager recoveryManager;
    private String identifier;

    WaitConfirmation(long timeOut, RecoveryManager recoveryManager, String identifier) {
        this.timeOut = timeOut;
        this.recoveryManager = recoveryManager;
        this.identifier = identifier;
        if (log.isDebugEnabled()) {
            log.debug("init : " + identifier);
        }
    }

    public void run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Before : getParticipantsClusterList().size():" + this.recoveryManager.getPendingConfirmationChengesLogById(this.identifier).getConfirmationList().size());
            }
            Thread.sleep(this.timeOut);
            PendingConfirmationChengesLog confirmationChengesLog = this.recoveryManager.getPendingConfirmationChengesLogById(this.identifier);
            ArrayList<String> notConfirmationList = new ArrayList<String>(this.recoveryManager.getParticipantsClusterList());
            notConfirmationList.removeAll(confirmationChengesLog.getConfirmationList());
            if (notConfirmationList.size() > 0) {
                confirmationChengesLog.setNotConfirmationList(notConfirmationList);
                String fileName = this.recoveryManager.save(this.identifier);
                if (log.isDebugEnabled()) {
                    log.debug("save : " + this.identifier);
                }
                for (String ownerName : confirmationChengesLog.getConfirmationList()) {
                    this.recoveryManager.removeChangesLog(this.identifier, ownerName);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("After : getParticipantsClusterList().size():" + confirmationChengesLog.getConfirmationList().size());
            }
            this.recoveryManager.remove(this.identifier);
            if (log.isDebugEnabled()) {
                log.debug("remove : " + this.identifier);
            }
        }
        catch (InterruptedException e) {
            log.error("Can't save ChangesLog", e);
        }
        catch (FileNotFoundException e) {
            log.error("Can't save ChangesLog", e);
        }
        catch (IOException e) {
            log.error("Can't save ChangesLog", e);
        }
        catch (Exception e) {
            log.error("Can't save ChangesLog", e);
        }
    }
}

