/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;

public class NtFileTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger(NtFileTestCase.class);

    public NtFileTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        log.info("NtFileTestCase inited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer addNtFile(String repoPath, String fileName, Long fileSize) {
        StringBuffer sb = new StringBuffer();
        log.info("ReplicationTestService.addNTFile run");
        byte[] buf = new byte[1024];
        File tempFile = null;
        try {
            tempFile = File.createTempFile("tempF", "_");
            FileOutputStream fos = new FileOutputStream(tempFile);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)(i % 255);
            }
            for (long i = 0L; i < fileSize / 1024L; ++i) {
                fos.write(buf);
            }
            fos.write(buf, 0, (int)(fileSize % 1024L));
            fos.close();
            long start = System.currentTimeMillis();
            Node cool = this.addNodePath(repoPath).addNode(fileName, "nt:file");
            Node contentNode = cool.addNode("jcr:content", "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:data", new FileInputStream(tempFile));
            contentNode.setProperty("jcr:mimeType", "application/octet-stream");
            contentNode.setProperty("jcr:lastModified", this.session.getValueFactory().createValue(Calendar.getInstance()));
            this.session.save();
            long end = System.currentTimeMillis();
            log.info("The time of the adding of nt:file : " + (double)(end - start) / 1000.0 + " sec");
            sb.append("ok");
        }
        catch (Exception e) {
            log.error("Can't save nt:file : ", e);
            sb.append("fail");
        }
        finally {
            tempFile.delete();
        }
        return sb;
    }

    public StringBuffer checkNtFile(String repoPath, String fileName, Long fileSize) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node checkNode = (Node)this.session.getItem(normalizePath);
            Node ntFile = checkNode.getNode(fileName);
            InputStream stream = ntFile.getNode("jcr:content").getProperty("jcr:data").getStream();
            byte[] buf = new byte[1024];
            long length = 0L;
            int lenReads = 0;
            while ((lenReads = stream.read(buf)) > 0) {
                length += (long)lenReads;
            }
            if (length == fileSize) {
                sb.append("ok");
            } else {
                sb.append("fail");
            }
        }
        catch (PathNotFoundException e) {
            log.error("Can't get node : " + normalizePath, e);
            sb.append("fail");
        }
        catch (RepositoryException e) {
            log.error("CheckNtFile fail", e);
            sb.append("fail");
        }
        catch (Exception e) {
            log.error("CheckNtFile fail", e);
            sb.append("fail");
        }
        return sb;
    }
}

