/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import javax.jcr.RepositoryException;
import javax.management.MBeanServer;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.core.SessionFactory;
import org.exoplatform.services.jcr.impl.core.WorkspaceInitializer;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceContainer
extends ExoContainer {
    protected static Log log = ExoLogger.getLogger("jcr.WorkspaceContainer");
    private final String name;
    private final RepositoryContainer repositoryContainer;
    private final MBeanServer mbeanServer;
    private final String mbeanContext;

    public WorkspaceContainer(RepositoryContainer parent, WorkspaceEntry config) throws RepositoryException, RepositoryConfigurationException {
        super(new MX4JComponentAdapterFactory(), parent);
        this.repositoryContainer = parent;
        this.name = config.getName();
        this.mbeanServer = this.createMBeanServer("jcrws" + this.name + "at" + this.repositoryContainer.getName() + "mx");
        this.mbeanContext = parent.getMBeanContext() + ",workspace=" + this.name;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getMBeanContext() {
        return this.mbeanContext;
    }

    public SessionFactory getSessionFactory() {
        return (SessionFactory)this.getComponentInstanceOfType(SessionFactory.class);
    }

    public WorkspaceInitializer getWorkspaceInitializer() {
        return (WorkspaceInitializer)this.getComponentInstanceOfType(WorkspaceInitializer.class);
    }

    public void stop() {
        try {
            this.stopContainer();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), e);
        }
        super.stop();
    }
}

