/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.xml.XMLChar;
import org.exoplatform.services.log.ExoLogger;

public class LocationFactory {
    protected static Log log = ExoLogger.getLogger("jcr.LocationFactory");
    private NamespaceAccessor namespaces;

    public LocationFactory(NamespaceAccessor namespaces) {
        this.namespaces = namespaces;
    }

    public JCRPath createRootLocation() throws RepositoryException {
        return this.parseNames("/", true);
    }

    public JCRPath createJCRPath(JCRPath parentLoc, String relPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        for (int i = 0; i < parentLoc.getEntries().length; ++i) {
            path.addEntry(parentLoc.getEntries()[i]);
        }
        JCRPath addPath = this.parseNames(relPath, false);
        for (int i = 0; i < addPath.getEntries().length; ++i) {
            path.addEntry(addPath.getEntries()[i]);
        }
        return path;
    }

    public JCRPath parseAbsPath(String absPath) throws RepositoryException {
        return this.parseNames(absPath, true);
    }

    public JCRPath parseRelPath(String relPath) throws RepositoryException {
        return this.parseNames(relPath, false);
    }

    public JCRPath parseJCRPath(String path) throws RepositoryException {
        if (LocationFactory.isAbsPathParseable(path)) {
            return this.parseAbsPath(path);
        }
        return this.parseRelPath(path);
    }

    public JCRPath createJCRPath(QPath qPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        for (int i = 0; i < qPath.getEntries().length; ++i) {
            QPathEntry entry = qPath.getEntries()[i];
            String prefix = this.namespaces.getNamespacePrefixByURI(entry.getNamespace());
            path.addEntry(entry.getNamespace(), entry.getName(), prefix, entry.getIndex());
        }
        return path;
    }

    public JCRName createJCRName(InternalQName qname) throws RepositoryException {
        String prefix = this.namespaces.getNamespacePrefixByURI(qname.getNamespace());
        return new JCRName(qname.getNamespace(), qname.getName(), prefix);
    }

    public String formatPathElement(QPathEntry qe) throws RepositoryException {
        String prefix = this.namespaces.getNamespacePrefixByURI(qe.getNamespace());
        JCRPath p = new JCRPath();
        p.addEntry(qe.getNamespace(), qe.getName(), prefix, qe.getIndex());
        return p.getEntries()[0].getAsString(false);
    }

    public JCRName parseJCRName(String name) throws RepositoryException {
        JCRPath.PathElement entry = this.parsePathEntry(new JCRPath(), name);
        return new JCRName(entry.getNamespace(), entry.getName(), entry.getPrefix());
    }

    public JCRPath.PathElement[] createRelPath(QPathEntry[] relPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        for (QPathEntry element : relPath) {
            String uri = this.namespaces.getNamespaceURIByPrefix(element.getNamespace());
            String prefix = this.namespaces.getNamespacePrefixByURI(uri);
            path.addEntry(uri, element.getName(), prefix, element.getIndex());
        }
        return path.getEntries();
    }

    private JCRPath.PathElement parsePathEntry(JCRPath path, String name) throws RepositoryException {
        int index = -1;
        if (name == null) {
            throw new RepositoryException("Name can not be null");
        }
        int delim = name.indexOf(":");
        int endOfName = name.length();
        int indexStart = name.indexOf("[");
        if (indexStart > 0) {
            int indexEnd = name.indexOf("]");
            if (indexEnd <= indexStart + 1 || indexEnd != name.length() - 1) {
                throw new RepositoryException("Invalid path entry " + name);
            }
            index = Integer.parseInt(name.substring(indexStart + 1, indexEnd));
            if (index <= 0) {
                throw new RepositoryException("Invalid path entry " + name);
            }
            endOfName = indexStart;
        }
        try {
            String prefix;
            if (delim <= 0) {
                prefix = "";
            } else {
                prefix = name.substring(0, delim);
                if (!XMLChar.isValidName(prefix)) {
                    throw new RepositoryException("Illegal path entry " + name);
                }
            }
            String someName = name.substring(delim + 1, endOfName);
            if (!this.isValidName(someName, !prefix.equals(""))) {
                throw new RepositoryException("Illegal path entry " + name);
            }
            path.addEntry(this.namespaces.getNamespaceURIByPrefix(prefix), someName, prefix, index);
            return (JCRPath.PathElement)path.getName();
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }

    private JCRPath parseNames(String path, boolean absolute) throws RepositoryException {
        if (path == null) {
            throw new RepositoryException("Illegal relPath " + path);
        }
        JCRPath jcrPath = new JCRPath();
        int start = 0;
        if (!absolute) {
            start = -1;
        }
        if (LocationFactory.isAbsPathParseable(path)) {
            if (!absolute) {
                throw new RepositoryException("Illegal relPath " + path);
            }
            jcrPath.addEntry(this.namespaces.getNamespaceURIByPrefix(""), "", "", -1);
        } else if (absolute) {
            throw new RepositoryException("Illegal absPath " + path);
        }
        int end = 0;
        while (end >= 0) {
            end = path.indexOf(47, start + 1);
            String qname = path.substring(start + 1, end == -1 ? path.length() : end);
            if (start + 1 == path.length()) {
                return jcrPath;
            }
            this.parsePathEntry(jcrPath, qname);
            start = end;
        }
        return jcrPath;
    }

    private static boolean isAbsPathParseable(String str) {
        return str.startsWith("/");
    }

    private boolean isNonspace(String str, char ch) {
        if (ch == '|') {
            log.warn("Path entry " + str + " contain illegal char " + ch);
        }
        return ch != '\t' && ch != '\n' && ch != '\f' && ch != '\r' && ch != ' ' && ch != '/' && ch != ':' && ch != '[' && ch != ']' && ch != '\'' && ch != '\"' && ch != '*';
    }

    private boolean isSimpleString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (this.isNonspace(str, ch) || ch == ' ') continue;
            return false;
        }
        return true;
    }

    private boolean isLocalName(String str) {
        int strLen = str.length();
        switch (strLen) {
            case 0: {
                return false;
            }
            case 1: {
                char ch = str.charAt(0);
                return this.isNonspace(str, ch) && ch != '.';
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                return ch0 == '.' && this.isNonspace(str, ch1) && ch1 != '.' || this.isNonspace(str, ch0) && ch0 != '.' && ch1 == '.' || this.isNonspace(str, ch0) && ch0 != '.' && this.isNonspace(str, ch1) && ch1 != '.';
            }
        }
        return this.isNonspace(str, str.charAt(0)) && this.isSimpleString(str.substring(1, strLen - 1)) && this.isNonspace(str, str.charAt(strLen - 1));
    }

    private boolean isSimpleName(String str) {
        int strLen = str.length();
        switch (strLen) {
            case 0: {
                return false;
            }
            case 1: {
                return this.isNonspace(str, str.charAt(0));
            }
            case 2: {
                return this.isNonspace(str, str.charAt(0)) && this.isNonspace(str, str.charAt(1));
            }
        }
        return this.isNonspace(str, str.charAt(0)) && this.isSimpleString(str.substring(1, strLen - 1)) && this.isNonspace(str, str.charAt(strLen - 1));
    }

    private boolean isValidName(String str, boolean prefixed) {
        return prefixed ? this.isLocalName(str) : this.isSimpleName(str) || str.equals(".") || str.equals("..") || str.equals("*");
    }
}

