/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDataPersister {
    public static Log log = ExoLogger.getLogger("jcr.NamespaceDataPersister");
    private DataManager dataManager;
    private PlainChangesLog changesLog;
    private NodeData nsRoot;

    public NamespaceDataPersister(DataManager dataManager) {
        this.dataManager = dataManager;
        this.changesLog = new PlainChangesLogImpl();
        try {
            NodeData jcrSystem = (NodeData)dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.nsRoot = (NodeData)dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
            }
        }
        catch (RepositoryException e) {
            log.warn("Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
        }
    }

    DataManager getDataManager() {
        return this.dataManager;
    }

    public void initStorage(NodeData nsSystem, boolean addACL, Map<String, String> namespaces) throws RepositoryException {
        TransientNodeData exoNamespaces = TransientNodeData.createNodeData(nsSystem, Constants.EXO_NAMESPACES, Constants.NT_UNSTRUCTURED);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(exoNamespaces, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(exoNamespaces.getPrimaryTypeName()));
        this.changesLog.add(ItemState.createAddedState(exoNamespaces)).add(ItemState.createAddedState(primaryType));
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            exoNamespaces.setMixinTypeNames(mixins);
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            this.changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            this.changesLog.add(new ItemState(exoNamespaces, 16, false, null));
        }
        this.nsRoot = exoNamespaces;
        for (String nsKey : namespaces.keySet()) {
            if (nsKey != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Namespace " + nsKey + " " + namespaces.get(nsKey));
                }
                this.addNamespace(nsKey, namespaces.get(nsKey));
                if (!log.isDebugEnabled()) continue;
                log.debug("Namespace " + nsKey + " is initialized.");
                continue;
            }
            log.warn("Namespace is " + nsKey + " " + namespaces.get(nsKey));
        }
        this.saveChanges();
    }

    public void addNamespace(String prefix, String uri) throws RepositoryException {
        if (!this.isInialized()) {
            log.warn("Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, new InternalQName("", prefix), Constants.EXO_NAMESPACE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData(nsNode, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(nsNode.getPrimaryTypeName()));
        TransientPropertyData exoUri = TransientPropertyData.createPropertyData(nsNode, Constants.EXO_URI_NAME, 1, false);
        exoUri.setValue(new TransientValueData(uri));
        TransientPropertyData exoPrefix = TransientPropertyData.createPropertyData(nsNode, Constants.EXO_PREFIX, 1, false);
        exoPrefix.setValue(new TransientValueData(prefix));
        this.changesLog.add(ItemState.createAddedState(nsNode)).add(ItemState.createAddedState(primaryType)).add(ItemState.createAddedState(exoUri)).add(ItemState.createAddedState(exoPrefix));
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        if (!this.isInialized()) {
            log.warn("Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        PlainChangesLogImpl plainChangesLogImpl = new PlainChangesLogImpl();
        ItemData prefData = this.dataManager.getItemData(this.nsRoot, new QPathEntry(new InternalQName("", prefix), 0));
        if (prefData != null && prefData.isNode()) {
            List<PropertyData> childs = this.dataManager.getChildPropertiesData((NodeData)prefData);
            for (PropertyData propertyData : childs) {
                plainChangesLogImpl.add(ItemState.createDeletedState(this.copyPropertyData(propertyData), true));
            }
        }
        plainChangesLogImpl.add(ItemState.createDeletedState(prefData, true));
        this.dataManager.save(new TransactionChangesLog(plainChangesLogImpl));
    }

    void loadNamespaces(Map<String, String> namespacesMap, Map<String, String> urisMap) throws RepositoryException {
        if (!this.isInialized()) {
            NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.nsRoot = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
            } else {
                throw new RepositoryException("/jcr:system is not found. Possible the workspace is not initialized properly");
            }
        }
        if (this.isInialized()) {
            NodeDataReader nsReader = new NodeDataReader(this.nsRoot, this.dataManager);
            nsReader.setRememberSkiped(true);
            nsReader.forNodesByType(Constants.EXO_NAMESPACE);
            nsReader.read();
            List<NodeDataReader> nsData = nsReader.getNodesByType(Constants.EXO_NAMESPACE);
            for (NodeDataReader nsr : nsData) {
                nsr.forProperty(Constants.EXO_URI_NAME, 1).forProperty(Constants.EXO_PREFIX, 1);
                nsr.read();
                try {
                    String exoUri = ValueDataConvertor.readString(nsr.getPropertyValue(Constants.EXO_URI_NAME));
                    String exoPrefix = ValueDataConvertor.readString(nsr.getPropertyValue(Constants.EXO_PREFIX));
                    namespacesMap.put(exoPrefix, exoUri);
                    urisMap.put(exoUri, exoPrefix);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Namespace " + exoPrefix + " is loaded");
                }
                catch (IOException e) {
                    throw new RepositoryException("Namespace load error " + e, e);
                }
            }
            for (NodeData skipedNs : nsReader.getSkiped()) {
                log.warn("Namespace node " + skipedNs.getQPath().getName().getAsString() + " (primary type '" + skipedNs.getPrimaryTypeName().getAsString() + "') is not supported for loading. Nodes with 'exo:namespace' node type is supported only now.");
            }
        } else {
            log.warn("Namespace storage (/jcr:system/exo:namespaces node) is not initialized. No namespaces loaded.");
        }
    }

    void saveChanges() throws RepositoryException, InvalidItemStateException {
        this.dataManager.save(new TransactionChangesLog(this.changesLog));
        this.changesLog.clear();
    }

    private boolean isInialized() {
        return this.nsRoot != null;
    }

    private TransientItemData copyPropertyData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
        ArrayList<TransientValueData> values = null;
        if (prop.getValues() != null) {
            values = new ArrayList<TransientValueData>();
            for (ValueData val : prop.getValues()) {
                values.add(((AbstractValueData)val).createTransientCopy());
            }
        }
        newData.setValues(values);
        return newData;
    }
}

