/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.NamespaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.ExtendedNamespaceRegistry;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceRegistryImpl
implements ExtendedNamespaceRegistry {
    public static final Map<String, String> DEF_NAMESPACES = new HashMap<String, String>();
    public static final Map<String, String> DEF_PREFIXES = new HashMap<String, String>();
    private static final Set<String> PROTECTED_NAMESPACES = new HashSet<String>();
    protected static final Log log = ExoLogger.getLogger("jcr.NamespaceRegistryImpl");
    private Map<String, String> namespaces;
    private NamespaceDataPersister persister;
    private Map<String, String> prefixes;
    private HashSet<QueryHandler> queryHandlers;

    public NamespaceRegistryImpl() {
        this.namespaces = DEF_NAMESPACES;
        this.prefixes = DEF_PREFIXES;
        this.queryHandlers = new HashSet();
    }

    public NamespaceRegistryImpl(NamespaceDataPersister persister) {
        this.namespaces = new HashMap<String, String>(DEF_NAMESPACES);
        this.prefixes = new HashMap<String, String>(DEF_PREFIXES);
        this.persister = persister;
        this.queryHandlers = new HashSet();
    }

    @Override
    public String[] getAllNamespacePrefixes() {
        return this.getPrefixes();
    }

    @Override
    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        return this.getPrefix(uri);
    }

    @Override
    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException {
        return this.getURI(prefix);
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.prefixes.get(uri);
        if (prefix != null) {
            return prefix;
        }
        throw new NamespaceException("Prefix for " + uri + " not found");
    }

    @Override
    public String[] getPrefixes() {
        return this.namespaces.keySet().toArray(new String[this.namespaces.keySet().size()]);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        String uri = this.namespaces.get(prefix);
        if (uri == null) {
            throw new NamespaceException("Unknown Prefix " + prefix);
        }
        return uri;
    }

    @Override
    public String[] getURIs() {
        return this.namespaces.values().toArray(new String[this.namespaces.size()]);
    }

    public boolean isDefaultNamespace(String uri) {
        return DEF_PREFIXES.containsKey(uri);
    }

    public boolean isDefaultPrefix(String prefix) {
        return DEF_NAMESPACES.containsKey(prefix);
    }

    public boolean isPrefixMaped(String prefix) {
        return this.namespaces.containsKey(prefix);
    }

    public boolean isUriRegistered(String uri) {
        return this.prefixes.containsKey(uri);
    }

    public void loadFromStorage() throws RepositoryException {
        try {
            this.persister.loadNamespaces(this.namespaces, this.prefixes);
        }
        catch (PathNotFoundException e) {
            log.info("Namespaces storage (/jcr:system/exo:namespaces) is not accessible. Default namespaces only will be used. " + e);
            return;
        }
    }

    @Override
    public synchronized void registerNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        this.validateNamespace(prefix, uri);
        if (this.namespaces.containsKey(prefix)) {
            this.unregisterNamespace(prefix);
        } else if (this.prefixes.containsKey(uri)) {
            this.unregisterNamespace(this.prefixes.get(uri));
        }
        this.persister.addNamespace(prefix, uri);
        this.persister.saveChanges();
        String newPrefix = new String(prefix);
        String newUri = new String(uri);
        this.namespaces.put(newPrefix, newUri);
        this.prefixes.put(newUri, newPrefix);
    }

    @Override
    public void unregisterNamespace(String prefix) throws NamespaceException, RepositoryException {
        if (this.namespaces.get(prefix) == null) {
            throw new NamespaceException("Prefix " + prefix + " is not registered");
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            throw new NamespaceException("Prefix " + prefix + " is protected");
        }
        Set<String> nodes = this.getNodes(prefix);
        if (nodes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to unregister namespace");
            buffer.append(prefix);
            buffer.append(" because of following nodes:  ");
            DataManager dm = this.persister.getDataManager();
            for (String uuid : nodes) {
                ItemData item = dm.getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                buffer.append(item.getQPath().getAsString());
            }
            buffer.append(" contains whese prefix  ");
            throw new NamespaceException(buffer.toString());
        }
        this.prefixes.remove(this.getURI(prefix));
        this.namespaces.remove(prefix);
        this.persister.removeNamespace(prefix);
    }

    public void validateNamespace(String prefix, String uri) throws NamespaceException, RepositoryException {
        if (prefix.indexOf(":") > 0) {
            throw new RepositoryException("Namespace prefix should not contain ':' " + prefix);
        }
        if (PROTECTED_NAMESPACES.contains(prefix)) {
            if (uri == null) {
                throw new NamespaceException("Can not remove built-in namespace");
            }
            throw new NamespaceException("Can not change built-in namespace");
        }
        if (prefix.toLowerCase().startsWith("xml")) {
            throw new NamespaceException("Can not re-assign prefix that start with 'xml'");
        }
        if (uri == null) {
            throw new NamespaceException("Can not register NULL URI!");
        }
    }

    public void addQueryHandler(QueryHandler queryHandler) {
        this.queryHandlers.add(queryHandler);
    }

    public Set<String> getNodes(String prefix) throws RepositoryException {
        LocationFactory locationFactory = new LocationFactory(this);
        ValueFactoryImpl valueFactory = new ValueFactoryImpl(locationFactory);
        BooleanQuery query = new BooleanQuery();
        query.add(new WildcardQuery(new Term(FieldNames.LABEL, prefix + ":*")), BooleanClause.Occur.SHOULD);
        query.add(new WildcardQuery(new Term(FieldNames.PROPERTIES_SET, prefix + ":*")), BooleanClause.Occur.SHOULD);
        Set<String> result = this.getNodes(query);
        Set<String> propSet = this.getNodes(new WildcardQuery(new Term(FieldNames.PROPERTIES, "*" + prefix + ":*")));
        for (String uuid : propSet) {
            if (!this.isPrefixMatch(valueFactory, uuid, prefix)) continue;
            result.add(uuid);
        }
        return result;
    }

    private boolean isPrefixMatch(ValueFactoryImpl valueFactory, String uuid, String prefix) throws RepositoryException {
        DataManager dm = this.persister.getDataManager();
        ItemData node = dm.getItemData(uuid);
        if (node != null && node.isNode()) {
            List<PropertyData> props = dm.getChildPropertiesData((NodeData)node);
            for (PropertyData propertyData : props) {
                if (propertyData.getType() != 8 && propertyData.getType() != 7) continue;
                for (ValueData vdata : propertyData.getValues()) {
                    Value val = valueFactory.loadValue(((AbstractValueData)vdata).createTransientCopy(), propertyData.getType());
                    if (!(propertyData.getType() == 8 ? this.isPrefixMatch(((PathValue)val).getQPath(), prefix) : propertyData.getType() == 7 && this.isPrefixMatch(((NameValue)val).getQName(), prefix))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPrefixMatch(QPath value, String prefix) throws NamespaceException {
        for (int i = 0; i < value.getEntries().length; ++i) {
            if (!this.isPrefixMatch(value.getEntries()[i], prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isPrefixMatch(InternalQName value, String prefix) throws NamespaceException {
        return value.getNamespace().equals(this.getURI(prefix));
    }

    private Set<String> getNodes(Query query) throws RepositoryException {
        HashSet<String> result = new HashSet<String>();
        Iterator<QueryHandler> it = this.queryHandlers.iterator();
        try {
            while (it.hasNext()) {
                QueryHandler queryHandler = it.next();
                QueryHits hits = queryHandler.executeQuery(query, true, new InternalQName[0], new boolean[0]);
                for (int i = 0; i < hits.length(); ++i) {
                    result.add(hits.getFieldContent(i, FieldNames.UUID));
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    static {
        DEF_NAMESPACES.put("", "");
        DEF_NAMESPACES.put("jcr", "http://www.jcp.org/jcr/1.0");
        DEF_NAMESPACES.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        DEF_NAMESPACES.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        DEF_NAMESPACES.put("xml", "http://www.w3.org/XML/1998/namespace");
        DEF_NAMESPACES.put("sv", "http://www.jcp.org/jcr/sv/1.0");
        DEF_NAMESPACES.put("exo", "http://www.exoplatform.com/jcr/exo/1.0");
        DEF_NAMESPACES.put("xs", "http://www.w3.org/2001/XMLSchema");
        DEF_NAMESPACES.put("fn", "http://www.w3.org/2005/xpath-functions");
        DEF_NAMESPACES.put("fn_old", "http://www.w3.org/2004/10/xpath-functions");
        DEF_NAMESPACES.put("rep", "internal");
        DEF_PREFIXES.put("", "");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/1.0", "jcr");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/nt/1.0", "nt");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/mix/1.0", "mix");
        DEF_PREFIXES.put("http://www.w3.org/XML/1998/namespace", "mix");
        DEF_PREFIXES.put("http://www.jcp.org/jcr/sv/1.0", "sv");
        DEF_PREFIXES.put("http://www.exoplatform.com/jcr/exo/1.0", "exo");
        DEF_PREFIXES.put("http://www.w3.org/2001/XMLSchema", "xs");
        DEF_PREFIXES.put("http://www.w3.org/2005/xpath-functions", "fn");
        DEF_PREFIXES.put("http://www.w3.org/2004/10/xpath-functions", "fn_old");
        DEF_PREFIXES.put("internal", "rep");
        PROTECTED_NAMESPACES.add("jcr");
        PROTECTED_NAMESPACES.add("nt");
        PROTECTED_NAMESPACES.add("mix");
        PROTECTED_NAMESPACES.add("xml");
        PROTECTED_NAMESPACES.add("sv");
        PROTECTED_NAMESPACES.add("exo");
    }
}

