/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.AbstractDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.RelatedDefinition;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDefinitionComparator
extends AbstractDefinitionComparator<NodeDefinitionData> {
    private static final Log LOG = ExoLogger.getLogger(NodeDefinitionComparator.class);

    public NodeDefinitionComparator(NodeTypeDataManagerImpl nodeTypeDataManager, DataManager persister) {
        super(nodeTypeDataManager, persister);
    }

    public PlainChangesLog compare(NodeTypeData registeredNodeType, NodeDefinitionData[] ancestorDefinition, NodeDefinitionData[] recipientDefinition) throws ConstraintViolationException, RepositoryException {
        ArrayList sameDefinitionData = new ArrayList();
        ArrayList<RelatedDefinition<NodeDefinitionData>> changedDefinitionData = new ArrayList<RelatedDefinition<NodeDefinitionData>>();
        ArrayList<NodeDefinitionData> newDefinitionData = new ArrayList<NodeDefinitionData>();
        ArrayList<NodeDefinitionData> removedDefinitionData = new ArrayList<NodeDefinitionData>();
        this.init(ancestorDefinition, recipientDefinition, sameDefinitionData, changedDefinitionData, newDefinitionData, removedDefinitionData);
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.validateRemoved(registeredNodeType, removedDefinitionData, recipientDefinition);
        Set<String> nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName());
        this.validateAdded(registeredNodeType.getName(), newDefinitionData, nodes, recipientDefinition);
        this.validateChanged(registeredNodeType.getName(), changedDefinitionData, nodes, recipientDefinition);
        this.doAdd(newDefinitionData, changesLog, nodes, registeredNodeType);
        return changesLog;
    }

    private void checkMandatoryItems(Set<String> nodes, NodeDefinitionData nodeDefinitionData) throws RepositoryException, ConstraintViolationException {
        for (String uuid : nodes) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            ItemData child = this.persister.getItemData(nodeData, new QPathEntry(nodeDefinitionData.getName(), 0));
            if (child != null && child.isNode()) continue;
            throw new ConstraintViolationException("Fail to  add mandatory and not auto-created child node definition " + nodeDefinitionData.getName().getAsString() + " for " + nodeDefinitionData.getDeclaringNodeType().getAsString() + " because node " + nodeData.getQPath().getAsString() + " doesn't contains child node with name " + nodeDefinitionData.getName().getAsString());
        }
    }

    private void checkRequiredPrimaryType(InternalQName registeredNodeType, Set<String> nodes, InternalQName[] ancestorRequiredPrimaryTypes, NodeDefinitionData recipientDefinitionData, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        InternalQName[] requiredPrimaryTypes = recipientDefinitionData.getRequiredPrimaryTypes();
        for (String uuid : nodes) {
            int i;
            List<NodeData> childs;
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            if (recipientDefinitionData.getName().equals(Constants.JCR_ANY_NAME)) {
                childs = this.persister.getChildNodesData(nodeData);
                for (NodeData child : childs) {
                    if (!this.isResidualMatch(child.getQPath().getName(), allRecipientDefinition)) continue;
                    for (i = 0; i < requiredPrimaryTypes.length; ++i) {
                        if (this.nodeTypeDataManager.isNodeType(requiredPrimaryTypes[i], child.getPrimaryTypeName(), child.getMixinTypeNames())) continue;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Fail to change ");
                        buffer.append(recipientDefinitionData.getName().getAsString());
                        buffer.append(" node definition for ");
                        buffer.append(registeredNodeType.getAsString());
                        buffer.append("node type from ");
                        if (ancestorRequiredPrimaryTypes != null) {
                            buffer.append(Arrays.toString(ancestorRequiredPrimaryTypes));
                        } else {
                            buffer.append(" '' ");
                        }
                        buffer.append(" to ");
                        buffer.append(Arrays.toString(recipientDefinitionData.getRequiredPrimaryTypes()));
                        buffer.append(" because ");
                        buffer.append(child.getQPath().getAsString());
                        buffer.append(" doesn't much ");
                        buffer.append(requiredPrimaryTypes[i].getAsString());
                        buffer.append(" as required primary type");
                        throw new ConstraintViolationException(buffer.toString());
                    }
                }
                continue;
            }
            childs = this.persister.getChildNodesData(nodeData);
            for (NodeData child : childs) {
                if (!child.getQPath().getName().equals(recipientDefinitionData.getName())) continue;
                for (i = 0; i < requiredPrimaryTypes.length; ++i) {
                    if (this.nodeTypeDataManager.isNodeType(requiredPrimaryTypes[i], child.getPrimaryTypeName(), child.getMixinTypeNames())) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Fail to change ");
                    buffer.append(recipientDefinitionData.getName().getAsString());
                    buffer.append(" node definition for ");
                    buffer.append(registeredNodeType.getAsString());
                    buffer.append("node type from ");
                    if (ancestorRequiredPrimaryTypes != null) {
                        buffer.append(Arrays.toString(ancestorRequiredPrimaryTypes));
                    } else {
                        buffer.append(" '' ");
                    }
                    buffer.append(" to ");
                    buffer.append(Arrays.toString(recipientDefinitionData.getRequiredPrimaryTypes()));
                    buffer.append(" because ");
                    buffer.append(child.getQPath().getAsString());
                    buffer.append("doesn't much ");
                    buffer.append(requiredPrimaryTypes[i].getAsString());
                    buffer.append(" as required primary type");
                    throw new ConstraintViolationException(buffer.toString());
                }
            }
        }
    }

    private void checkSameNameSibling(InternalQName registeredNodeType, Set<String> nodes, InternalQName recipientName, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (String uuid : nodes) {
            List<NodeData> childs2;
            List<NodeData> childs;
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            if (recipientName.equals(Constants.JCR_ANY_NAME)) {
                childs = this.persister.getChildNodesData(nodeData);
                for (NodeData child : childs) {
                    if (!this.isResidualMatch(child.getQPath().getName(), allRecipientDefinition)) continue;
                    childs2 = this.persister.getChildNodesData(child);
                    for (NodeData child2 : childs2) {
                        if (child2.getQPath().getIndex() <= 1) continue;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("Fail to change ");
                        buffer.append(recipientName.getAsString());
                        buffer.append(" node definition for ");
                        buffer.append(registeredNodeType.getAsString());
                        buffer.append("node type from AllowsSameNameSiblings = true to AllowsSameNameSiblings = false");
                        buffer.append(" because ");
                        buffer.append(child.getQPath().getAsString());
                        buffer.append(" contains more then one child with name");
                        buffer.append(child2.getQPath().getName().getAsString());
                        throw new ConstraintViolationException(buffer.toString());
                    }
                }
                continue;
            }
            childs = this.persister.getChildNodesData(nodeData);
            for (NodeData child : childs) {
                if (!child.getQPath().getName().equals(recipientName)) continue;
                childs2 = this.persister.getChildNodesData(child);
                for (NodeData child2 : childs2) {
                    if (child2.getQPath().getIndex() <= 1) continue;
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("Fail to change ");
                    buffer.append(recipientName.getAsString());
                    buffer.append(" node definition for ");
                    buffer.append(registeredNodeType.getAsString());
                    buffer.append("node type from AllowsSameNameSiblings = true to AllowsSameNameSiblings = false");
                    buffer.append(" because ");
                    buffer.append(child.getQPath().getAsString());
                    buffer.append(" contains more then one child with name");
                    buffer.append(child2.getQPath().getName().getAsString());
                    throw new ConstraintViolationException(buffer.toString());
                }
            }
        }
    }

    private void doAdd(List<NodeDefinitionData> toAddList, PlainChangesLog changesLog, Set<String> nodes, NodeTypeData registeredNodeType) throws RepositoryException {
        for (String uuid : nodes) {
            NodeData nodeData = (NodeData)this.persister.getItemData(uuid);
            for (NodeDefinitionData newNodeDefinitionData : toAddList) {
                if (newNodeDefinitionData.getName().equals(Constants.JCR_ANY_NAME) || !newNodeDefinitionData.isAutoCreated()) continue;
                changesLog.addAll(this.nodeTypeDataManager.makeAutoCreatedNodes(nodeData, new NodeDefinitionData[]{newNodeDefinitionData}, this.persister, nodeData.getACL().getOwner()).getAllStates());
            }
        }
    }

    private void validateAdded(InternalQName nodeTypeName, List<NodeDefinitionData> newDefinitionData, Set<String> nodes, NodeDefinitionData[] recipientDefinition) throws RepositoryException {
        for (NodeDefinitionData nodeDefinitionData : newDefinitionData) {
            if (nodeDefinitionData.getName().equals(Constants.JCR_ANY_NAME)) {
                this.checkRequiredPrimaryType(nodeTypeName, nodes, null, nodeDefinitionData, recipientDefinition);
                this.checkSameNameSibling(nodeTypeName, nodes, nodeDefinitionData.getName(), recipientDefinition);
                continue;
            }
            this.checkRequiredPrimaryType(nodeTypeName, nodes, null, nodeDefinitionData, recipientDefinition);
            this.checkSameNameSibling(nodeTypeName, nodes, nodeDefinitionData.getName(), recipientDefinition);
            if (!nodeDefinitionData.isMandatory() || nodeDefinitionData.isAutoCreated()) continue;
            this.checkMandatoryItems(nodes, nodeDefinitionData);
        }
    }

    private void validateChanged(InternalQName registeredNodeType, List<RelatedDefinition<NodeDefinitionData>> changedDefinitionData, Set<String> nodes, NodeDefinitionData[] allRecipientDefinition) throws RepositoryException {
        for (RelatedDefinition<NodeDefinitionData> changedDefinitions : changedDefinitionData) {
            ItemData child;
            NodeData nodeData;
            NodeDefinitionData ancestorDefinitionData = changedDefinitions.getAncestorDefinition();
            NodeDefinitionData recipientDefinitionData = changedDefinitions.getRecepientDefinition();
            if (!ancestorDefinitionData.isMandatory() && recipientDefinitionData.isMandatory()) {
                for (String uuid : nodes) {
                    nodeData = (NodeData)this.persister.getItemData(uuid);
                    child = this.persister.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
                    if (child != null && child.isNode()) continue;
                    String message = "Can not change " + recipientDefinitionData.getName().getAsString() + " node definition for " + registeredNodeType.getAsString() + " node type " + " from mandatory=false to mandatory = true , because " + " node " + nodeData.getQPath().getAsString() + " doesn't have child node with name " + recipientDefinitionData.getName().getAsString();
                    throw new RepositoryException(message);
                }
            }
            if (!ancestorDefinitionData.isProtected() && recipientDefinitionData.isProtected()) {
                for (String uuid : nodes) {
                    nodeData = (NodeData)this.persister.getItemData(uuid);
                    child = this.persister.getItemData(nodeData, new QPathEntry(recipientDefinitionData.getName(), 0));
                    if (child != null && child.isNode()) continue;
                    String message = "Fail to  change " + recipientDefinitionData.getName().getAsString() + " node definition for " + registeredNodeType.getAsString() + " node type  from rotected=false to Protected = true , because " + " node " + nodeData.getQPath().getAsString() + " doesn't have child node with name " + recipientDefinitionData.getName().getAsString();
                    throw new RepositoryException(message);
                }
            }
            if (!Arrays.deepEquals(ancestorDefinitionData.getRequiredPrimaryTypes(), recipientDefinitionData.getRequiredPrimaryTypes())) {
                this.checkRequiredPrimaryType(registeredNodeType, nodes, ancestorDefinitionData.getRequiredPrimaryTypes(), recipientDefinitionData, allRecipientDefinition);
            }
            if (!ancestorDefinitionData.isAllowsSameNameSiblings() || recipientDefinitionData.isAllowsSameNameSiblings()) continue;
            this.checkSameNameSibling(registeredNodeType, nodes, recipientDefinitionData.getName(), allRecipientDefinition);
        }
    }

    private void validateRemoved(NodeTypeData registeredNodeType, List<NodeDefinitionData> removedDefinitionData, NodeDefinitionData[] recipientDefinition) throws ConstraintViolationException, RepositoryException {
        for (NodeDefinitionData removeNodeDefinitionData : removedDefinitionData) {
            NodeData nodeData;
            Set<String> nodes;
            if (removeNodeDefinitionData.getName().equals(Constants.JCR_ANY_NAME)) {
                nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName());
                for (String uuid : nodes) {
                    nodeData = (NodeData)this.persister.getItemData(uuid);
                    List<NodeData> childs = this.persister.getChildNodesData(nodeData);
                    if (childs.size() <= 0) continue;
                    for (NodeData nodeData2 : childs) {
                        if (this.isNonResidualMatch(nodeData2.getQPath().getName(), recipientDefinition)) continue;
                        String msg = "Can't remove node definition " + removeNodeDefinitionData.getName().getAsString() + "  for " + registeredNodeType.getName().getAsString() + " node type because node " + nodeData.getQPath().getAsString() + " " + " countains child nodes with name " + nodeData2.getQPath().getName().getAsString();
                        throw new ConstraintViolationException(msg);
                    }
                }
                continue;
            }
            if (this.isResidualMatch(removeNodeDefinitionData.getName(), recipientDefinition)) continue;
            nodes = this.nodeTypeDataManager.getNodes(registeredNodeType.getName());
            for (String uuid : nodes) {
                nodeData = (NodeData)this.persister.getItemData(uuid);
                ItemData child = this.persister.getItemData(nodeData, new QPathEntry(removeNodeDefinitionData.getName(), 0));
                if (child == null || !child.isNode()) continue;
                throw new ConstraintViolationException("Can't remove node definition " + removeNodeDefinitionData.getName().getAsString() + "  for " + registeredNodeType.getName().getAsString() + " node type because node " + nodeData.getQPath().getAsString() + " " + " countains child node with name " + child.getQPath().getName().getAsString());
            }
        }
    }
}

