/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;

public class QueryHandlerContext {
    private final ItemDataConsumer stateMgr;
    private final NodeTypeDataManager nodeTypeDataManager;
    private final NamespaceRegistryImpl nsRegistry;
    private final String rootIdentifer;
    private final PropertyTypeRegistry propRegistry;
    private final QueryHandler parentHandler;
    private final DocumentReaderService extractor;
    private final String indexDirectory;

    public QueryHandlerContext(ItemDataConsumer stateMgr, String rootIdentifer, NodeTypeDataManager nodeTypeDataManager, NamespaceRegistryImpl nsRegistry, QueryHandler parentHandler, String indexDirectory, DocumentReaderService extractor) {
        this.stateMgr = stateMgr;
        this.rootIdentifer = rootIdentifer;
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.nsRegistry = nsRegistry;
        this.indexDirectory = indexDirectory;
        this.extractor = extractor;
        this.propRegistry = new PropertyTypeRegistry(nodeTypeDataManager);
        this.parentHandler = parentHandler;
        ((NodeTypeDataManagerImpl)this.nodeTypeDataManager).addListener(this.propRegistry);
    }

    public ItemDataConsumer getItemStateManager() {
        return this.stateMgr;
    }

    public String getRootNodeIdentifer() {
        return this.rootIdentifer;
    }

    public PropertyTypeRegistry getPropertyTypeRegistry() {
        return this.propRegistry;
    }

    public NodeTypeDataManager getNodeTypeDataManager() {
        return this.nodeTypeDataManager;
    }

    public NamespaceRegistryImpl getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public QueryHandler getParentHandler() {
        return this.parentHandler;
    }

    public void destroy() {
        ((NodeTypeDataManagerImpl)this.nodeTypeDataManager).removeListener(this.propRegistry);
    }

    public DocumentReaderService getExtractor() {
        return this.extractor;
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }
}

