/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.SystemSearchManagerHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchManager
implements Startable,
MandatoryItemsPersistenceListener {
    private static final Log log = ExoLogger.getLogger(SearchManager.class);
    protected final QueryHandlerEntry config;
    protected final DocumentReaderService extractor;
    protected QueryHandler handler;
    protected final ItemDataConsumer itemMgr;
    protected final NamespaceRegistryImpl nsReg;
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final SearchManager parentSearchManager;
    protected QPath indexingRoot;
    protected List<QPath> excludedPaths = new ArrayList<QPath>();
    private final ConfigurationManager cfm;

    public SearchManager(QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, SystemSearchManagerHolder parentSearchManager, DocumentReaderService extractor, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        this.extractor = extractor;
        this.config = config;
        this.nodeTypeDataManager = ntReg;
        this.nsReg = nsReg;
        this.itemMgr = itemMgr;
        this.cfm = cfm;
        this.parentSearchManager = parentSearchManager != null ? parentSearchManager.get() : null;
        itemMgr.addItemPersistenceListener(this);
        this.initializeQueryHandler();
    }

    public Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, Node node) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.handler.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, node);
        return query;
    }

    public Query createQuery(SessionImpl session, SessionDataManager sessionDataManager, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.handler.createQueryInstance();
        query.init(session, sessionDataManager, this.handler, statement, language);
        return query;
    }

    public QueryHandler getHandler() {
        return this.handler;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        if (this.handler == null) {
            return;
        }
        long time = System.currentTimeMillis();
        final HashSet<String> removedNodes = new HashSet<String>();
        final HashSet<String> addedNodes = new HashSet<String>();
        HashMap<String, List<ItemState>> updatedNodes = new HashMap<String, List<ItemState>>();
        for (ItemState itemState : changesLog.getAllStates()) {
            String uuid;
            if (this.isExcluded(itemState)) continue;
            String string = uuid = itemState.isNode() ? itemState.getData().getIdentifier() : itemState.getData().getParentIdentifier();
            if (itemState.isAdded()) {
                if (itemState.isNode()) {
                    addedNodes.add(uuid);
                    continue;
                }
                if (addedNodes.contains(uuid)) continue;
                this.createNewOrAdd(uuid, itemState, updatedNodes);
                continue;
            }
            if (itemState.isRenamed()) {
                if (itemState.isNode()) {
                    addedNodes.add(uuid);
                    continue;
                }
                this.createNewOrAdd(uuid, itemState, updatedNodes);
                continue;
            }
            if (itemState.isUpdated()) {
                this.createNewOrAdd(uuid, itemState, updatedNodes);
                continue;
            }
            if (itemState.isMixinChanged()) {
                this.createNewOrAdd(uuid, itemState, updatedNodes);
                continue;
            }
            if (!itemState.isDeleted()) continue;
            if (itemState.isNode()) {
                if (addedNodes.contains(uuid)) {
                    addedNodes.remove(uuid);
                    removedNodes.remove(uuid);
                } else {
                    removedNodes.add(uuid);
                }
                updatedNodes.remove(uuid);
                continue;
            }
            if (removedNodes.contains(uuid) || addedNodes.contains(uuid)) continue;
            this.createNewOrAdd(uuid, itemState, updatedNodes);
        }
        for (String uuid : updatedNodes.keySet()) {
            removedNodes.add(uuid);
            addedNodes.add(uuid);
        }
        Iterator<NodeData> addedStates = new Iterator<NodeData>(){
            private final Iterator<String> iter;
            {
                this.iter = addedNodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public NodeData next() {
                do {
                    String id = this.iter.next();
                    try {
                        ItemData item = SearchManager.this.itemMgr.getItemData(id);
                        if (item != null) {
                            if (item.isNode()) {
                                return (NodeData)item;
                            }
                            log.warn("Node not found, but property " + id + ", " + item.getQPath().getAsString() + " found. ");
                            continue;
                        }
                        log.warn("Unable to index node with id " + id + ", node does not exist.");
                    }
                    catch (RepositoryException e) {
                        log.error("Can't read next node data " + id, e);
                    }
                } while (this.iter.hasNext());
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        Iterator<String> removedIds = new Iterator<String>(){
            private final Iterator<String> iter;
            {
                this.iter = removedNodes.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                return this.nextNodeId();
            }

            public String nextNodeId() throws NoSuchElementException {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        if (removedNodes.size() > 0 || addedNodes.size() > 0) {
            try {
                this.handler.updateNodes(removedIds, addedStates);
            }
            catch (RepositoryException e) {
                log.error("Error indexing changes " + e, e);
            }
            catch (IOException e) {
                log.error("Error indexing changes " + e, e);
                try {
                    this.handler.logErrorChanges(removedNodes, addedNodes);
                }
                catch (IOException ioe) {
                    log.warn("Exception occure when errorLog writed. Error log is not complete. " + ioe, ioe);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("onEvent: indexing finished in " + String.valueOf(System.currentTimeMillis() - time) + " ms.");
        }
    }

    public void createNewOrAdd(String key, ItemState state, Map<String, List<ItemState>> updatedNodes) {
        List<ItemState> list = updatedNodes.get(key);
        if (list == null) {
            list = new ArrayList<ItemState>();
            updatedNodes.put(key, list);
        }
        list.add(state);
    }

    @Override
    public void start() {
        if (log.isDebugEnabled()) {
            log.debug("start");
        }
        this.excludedPaths.add(Constants.JCR_SYSTEM_PATH);
        if (this.config.getExcludedNodeIdentifers() != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.config.getExcludedNodeIdentifers());
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    ItemData excludeData = this.itemMgr.getItemData(stringTokenizer.nextToken());
                    if (excludeData == null) continue;
                    this.excludedPaths.add(excludeData.getQPath());
                }
                catch (RepositoryException e) {
                    log.warn(e.getLocalizedMessage());
                }
            }
        }
        this.indexingRoot = Constants.ROOT_PATH;
        if (this.config.getRootNodeIdentifer() != null) {
            try {
                ItemData indexingRootData = this.itemMgr.getItemData(this.config.getRootNodeIdentifer());
                if (indexingRootData != null && indexingRootData.isNode()) {
                    this.indexingRoot = indexingRootData.getQPath();
                }
            }
            catch (RepositoryException e) {
                log.warn(e.getLocalizedMessage() + " Indexing root set to " + this.indexingRoot.getAsString());
            }
        }
        this.handler.init();
    }

    @Override
    public void stop() {
        this.handler.close();
        log.info("Search manager stopped");
    }

    protected boolean isExcluded(ItemState event) {
        for (QPath excludedPath : this.excludedPaths) {
            if (!event.getData().getQPath().isDescendantOf(excludedPath) && !event.getData().getQPath().equals(excludedPath)) continue;
            return true;
        }
        return !event.getData().getQPath().isDescendantOf(this.indexingRoot) && !event.getData().getQPath().equals(this.indexingRoot);
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        QueryHandlerContext context = new QueryHandlerContext(this.itemMgr, this.config.getRootNodeIdentifer() != null ? this.config.getRootNodeIdentifer() : "00exo0jcr0root0uuid0000000000000", this.nodeTypeDataManager, this.nsReg, parentHandler, this.config.getIndexDir(), this.extractor);
        return context;
    }

    private void initializeQueryHandler() throws RepositoryException, RepositoryConfigurationException {
        String className = this.config.getType();
        if (className == null) {
            throw new RepositoryConfigurationException("Content hanler       configuration fail");
        }
        try {
            Class<?> qHandlerClass = Class.forName(className, true, this.getClass().getClassLoader());
            Constructor<?> constuctor = qHandlerClass.getConstructor(QueryHandlerEntry.class, ConfigurationManager.class);
            this.handler = (QueryHandler)constuctor.newInstance(this.config, this.cfm);
            QueryHandler parentHandler = this.parentSearchManager != null ? this.parentSearchManager.getHandler() : null;
            QueryHandlerContext context = this.createQueryHandlerContext(parentHandler);
            this.handler.setContext(context);
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), e);
        }
    }
}

