/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandlerContext;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;

public class SystemSearchManager
extends SearchManager {
    private final Log log = ExoLogger.getLogger("jcr.SystemSearchManager");
    private boolean isStarted = false;
    private List<ItemStateChangesLog> changesLogBuffer = new ArrayList<ItemStateChangesLog>();
    public static final String INDEX_DIR_SUFFIX = "system";

    public SystemSearchManager(QueryHandlerEntry config, NamespaceRegistryImpl nsReg, NodeTypeDataManager ntReg, WorkspacePersistentDataManager itemMgr, DocumentReaderService service, ConfigurationManager cfm) throws RepositoryException, RepositoryConfigurationException {
        super(config, nsReg, ntReg, itemMgr, null, service, cfm);
    }

    public void onSaveItems(ItemStateChangesLog changesLog) {
        if (!this.isStarted) {
            this.changesLogBuffer.add(changesLog);
        } else {
            super.onSaveItems(changesLog);
        }
    }

    public void start() {
        this.indexingRoot = Constants.JCR_SYSTEM_PATH;
        this.excludedPaths.remove(Constants.JCR_SYSTEM_PATH);
        this.isStarted = true;
        this.handler.init();
        for (ItemStateChangesLog bufferedChangesLog : this.changesLogBuffer) {
            super.onSaveItems(bufferedChangesLog);
        }
    }

    protected QueryHandlerContext createQueryHandlerContext(QueryHandler parentHandler) throws RepositoryConfigurationException {
        QueryHandlerContext context = new QueryHandlerContext(this.itemMgr, "00exo0jcr0system0uuid00000000000", this.nodeTypeDataManager, this.nsReg, parentHandler, this.config.getIndexDir() + "_" + INDEX_DIR_SUFFIX, this.extractor);
        return context;
    }
}

