/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.CommittableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.DynamicPooledExecutor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.log.ExoLogger;

abstract class AbstractIndex {
    private static final Log log = ExoLogger.getLogger(AbstractIndex.class);
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private static final DynamicPooledExecutor EXECUTOR = new DynamicPooledExecutor();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private boolean useCompoundFile = true;
    private int minMergeDocs = new Integer(100);
    private int maxMergeDocs = new Integer(Integer.MAX_VALUE);
    private int mergeFactor = new Integer(10);
    private int maxFieldLength = new Integer(10000);
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;
    private ReadOnlyIndexReader readOnlyReader;
    private IndexingQueue indexingQueue;

    AbstractIndex(Analyzer analyzer, Directory directory, DocNumberCache cache, IndexingQueue indexingQueue) throws IOException {
        this.analyzer = analyzer;
        this.directory = directory;
        this.cache = cache;
        this.indexingQueue = indexingQueue;
        if (!IndexReader.indexExists(directory)) {
            this.indexWriter = new IndexWriter(directory, analyzer);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    Directory getDirectory() throws IOException {
        return this.directory;
    }

    void addDocuments(Document[] docs) throws IOException {
        final IndexWriter writer = this.getIndexWriter();
        DynamicPooledExecutor.Command[] commands = new DynamicPooledExecutor.Command[docs.length];
        for (int i = 0; i < docs.length; ++i) {
            final Document doc = this.getFinishedDocument(docs[i]);
            commands[i] = new DynamicPooledExecutor.Command(){

                public Object call() throws Exception {
                    long time = System.currentTimeMillis();
                    writer.addDocument(doc);
                    return new Long(System.currentTimeMillis() - time);
                }
            };
        }
        DynamicPooledExecutor.Result[] results = EXECUTOR.executeAndWait(commands);
        this.invalidateSharedReader();
        IOException ex = null;
        for (int i = 0; i < results.length; ++i) {
            if (results[i].getException() != null) {
                Throwable cause = results[i].getException().getCause();
                if (ex == null) {
                    if (cause instanceof IOException) {
                        ex = (IOException)cause;
                        continue;
                    }
                    IOException e = new IOException();
                    e.initCause(cause);
                    ex = e;
                    continue;
                }
                log.warn("Exception while inverting document" + cause);
                continue;
            }
            log.debug("Inverted document in" + results[i].get() + "ms");
        }
        if (ex != null) {
            throw ex;
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        return this.getIndexReader().deleteDocuments(idTerm);
    }

    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            log.debug("closing IndexWriter.");
            this.indexWriter = null;
        }
        if (this.indexReader == null) {
            this.indexReader = new CommittableIndexReader(IndexReader.open(this.getDirectory()));
        }
        return this.indexReader;
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        CommittableIndexReader modifiableReader = this.getIndexReader();
        long modCount = modifiableReader.getModificationCount();
        if (this.readOnlyReader != null) {
            if (this.readOnlyReader.getDeletedDocsVersion() == modCount) {
                this.readOnlyReader.incrementRefCount();
                return this.readOnlyReader;
            }
            if (this.readOnlyReader.getRefCount() == 1) {
                this.readOnlyReader.updateDeletedDocs(modifiableReader);
                this.readOnlyReader.incrementRefCount();
                return this.readOnlyReader;
            }
            this.readOnlyReader.close();
            this.readOnlyReader = null;
        }
        BitSet deleted = new BitSet(modifiableReader.maxDoc());
        for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
            if (!modifiableReader.isDeleted(i)) continue;
            deleted.set(i);
        }
        if (this.sharedReader == null) {
            CachingIndexReader cr = new CachingIndexReader(IndexReader.open(this.getDirectory()), this.cache);
            this.sharedReader = new SharedIndexReader(cr);
        }
        this.readOnlyReader = new ReadOnlyIndexReader(this.sharedReader, deleted, modCount);
        this.readOnlyReader.incrementRefCount();
        return this.readOnlyReader;
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            log.debug("closing IndexReader.");
            this.indexReader = null;
        }
        if (this.indexWriter == null) {
            this.indexWriter = new IndexWriter(this.getDirectory(), this.analyzer);
            this.indexWriter.setMaxBufferedDocs(this.minMergeDocs);
            this.indexWriter.setMaxMergeDocs(this.maxMergeDocs);
            this.indexWriter.setMergeFactor(this.mergeFactor);
            this.indexWriter.setMaxFieldLength(this.maxFieldLength);
            this.indexWriter.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.setInfoStream(STREAM_LOGGER);
        }
        return this.indexWriter;
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        if (this.indexReader != null) {
            this.indexReader.commitDeleted();
        }
        if (this.indexWriter != null) {
            log.debug("committing IndexWriter.");
            this.indexWriter.close();
            this.indexWriter = null;
        }
        if (optimize) {
            IndexWriter writer = this.getIndexWriter();
            writer.optimize();
            writer.close();
            this.indexWriter = null;
        }
    }

    synchronized void close() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index writer: " + e.toString());
            }
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.indexReader = null;
        }
        if (this.readOnlyReader != null) {
            try {
                this.readOnlyReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
        }
        if (this.sharedReader != null) {
            try {
                this.sharedReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
        }
        if (this.directory != null) {
            try {
                this.directory.close();
            }
            catch (IOException e) {
                this.directory = null;
            }
        }
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        if (this.readOnlyReader != null) {
            this.readOnlyReader.close();
            this.readOnlyReader = null;
        }
        if (this.sharedReader != null) {
            this.sharedReader.close();
            this.sharedReader = null;
        }
    }

    private Document getFinishedDocument(Document doc) throws IOException {
        if (!Util.isDocumentReady(doc)) {
            Document copy = new Document();
            for (Field f : doc.getFields()) {
                Field field = null;
                Field.TermVector tv = this.getTermVectorParameter(f);
                Field.Store stored = this.getStoreParameter(f);
                Field.Index indexed = this.getIndexParameter(f);
                if (f.readerValue() != null) {
                    field = new Field(f.name(), new StringReader(""), tv);
                } else if (f.stringValue() != null) {
                    field = new Field(f.name(), f.stringValue(), stored, indexed, tv);
                } else if (f.isBinary()) {
                    field = new Field(f.name(), f.binaryValue(), stored);
                }
                if (field == null) continue;
                field.setOmitNorms(f.getOmitNorms());
                copy.add(field);
            }
            Document existing = this.indexingQueue.addDocument(doc);
            if (existing != null) {
                Util.disposeDocument(existing);
            }
            doc = copy;
        }
        return doc;
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            this.indexWriter.setUseCompoundFile(b);
        }
    }

    void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxBufferedDocs(minMergeDocs);
        }
    }

    void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxMergeDocs(maxMergeDocs);
        }
    }

    void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
        if (this.indexWriter != null) {
            this.indexWriter.setMergeFactor(mergeFactor);
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxFieldLength(maxFieldLength);
        }
    }

    private Field.Index getIndexParameter(Field f) {
        if (!f.isIndexed()) {
            return Field.Index.NO;
        }
        if (f.isTokenized()) {
            return Field.Index.TOKENIZED;
        }
        return Field.Index.UN_TOKENIZED;
    }

    private Field.Store getStoreParameter(Field f) {
        if (f.isCompressed()) {
            return Field.Store.COMPRESS;
        }
        if (f.isStored()) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    private Field.TermVector getTermVectorParameter(Field f) {
        if (f.isStorePositionWithTermVector() && f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS_OFFSETS;
        }
        if (f.isStorePositionWithTermVector()) {
            return Field.TermVector.WITH_POSITIONS;
        }
        if (f.isStoreOffsetWithTermVector()) {
            return Field.TermVector.WITH_OFFSETS;
        }
        if (f.isTermVectorStored()) {
            return Field.TermVector.YES;
        }
        return Field.TermVector.NO;
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

