/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.AggregateRule;
import org.exoplatform.services.jcr.util.Text;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AggregateRuleImpl
implements AggregateRule {
    private final LocationFactory resolver;
    private final InternalQName nodeTypeName;
    private final Rule[] rules;
    private final ItemDataConsumer ism;

    AggregateRuleImpl(Node config, LocationFactory resolver2, ItemDataConsumer ism) throws IllegalNameException, PathNotFoundException, RepositoryException {
        this.resolver = resolver2;
        this.nodeTypeName = this.getNodeTypeName(config);
        this.rules = this.getRules(config);
        this.ism = ism;
    }

    public NodeData getAggregateRoot(NodeData nodeState) throws RepositoryException {
        for (int i = 0; i < this.rules.length; ++i) {
            NodeData aggregateRoot = this.rules[i].matches(nodeState);
            if (aggregateRoot == null || !aggregateRoot.getPrimaryTypeName().equals(this.nodeTypeName)) continue;
            return aggregateRoot;
        }
        return null;
    }

    public NodeData[] getAggregatedNodeStates(NodeData nodeState) throws RepositoryException {
        if (nodeState.getPrimaryTypeName().equals(this.nodeTypeName)) {
            ArrayList<NodeData> nodeStates = new ArrayList<NodeData>();
            for (int i = 0; i < this.rules.length; ++i) {
                nodeStates.addAll(this.rules[i].resolve(nodeState));
            }
            if (nodeStates.size() > 0) {
                return nodeStates.toArray(new NodeData[nodeStates.size()]);
            }
        }
        return null;
    }

    private InternalQName getNodeTypeName(Node config) throws IllegalNameException, PathNotFoundException, RepositoryException {
        String ntString = config.getAttributes().getNamedItem("primaryType").getNodeValue();
        return this.resolver.parseJCRName(ntString).getInternalName();
    }

    private Rule[] getRules(Node config) throws IllegalNameException, PathNotFoundException, RepositoryException {
        ArrayList<Rule> newRules = new ArrayList<Rule>();
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("include")) continue;
            InternalQName ntName = null;
            Node ntAttr = n.getAttributes().getNamedItem("primaryType");
            if (ntAttr != null) {
                ntName = this.resolver.parseJCRName(ntAttr.getNodeValue()).getInternalName();
            }
            String[] elements = Text.explode(AggregateRuleImpl.getTextContent(n), 47);
            QPathEntry[] path = new QPathEntry[elements.length];
            for (int j = 0; j < elements.length; ++j) {
                path[j] = elements[j].equals("*") ? new QPathEntry(Constants.JCR_ANY_NAME, 0) : new QPathEntry(this.resolver.parseJCRName(elements[j]).getInternalName(), 0);
            }
            newRules.add(new Rule(new QPath(path), ntName));
        }
        return newRules.toArray(new Rule[newRules.size()]);
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Rule {
        private final InternalQName nodeTypeName;
        private final QPath pattern;

        private Rule(QPath pattern, InternalQName nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.pattern = pattern;
        }

        NodeData matches(NodeData nodeState) throws RepositoryException {
            if (this.nodeTypeName == null || nodeState.getPrimaryTypeName().equals(this.nodeTypeName)) {
                QPathEntry[] elements = this.pattern.getEntries();
                for (int e = elements.length - 1; e >= 0; --e) {
                    String parentId = nodeState.getParentIdentifier();
                    if (parentId == null) {
                        return null;
                    }
                    NodeData parent = (NodeData)AggregateRuleImpl.this.ism.getItemData(parentId);
                    if (elements[e].getName().equals("*")) {
                        nodeState = parent;
                        continue;
                    }
                    ItemData item = AggregateRuleImpl.this.ism.getItemData(nodeState.getIdentifier());
                    if (item != null && item.isNode() && elements[e].equals(item.getQPath().getName())) {
                        nodeState = parent;
                        continue;
                    }
                    return null;
                }
                return nodeState;
            }
            return null;
        }

        List<NodeData> resolve(NodeData nodeState) throws RepositoryException {
            ArrayList<NodeData> nodeStates = new ArrayList<NodeData>();
            this.resolve(nodeState, nodeStates, 0);
            return nodeStates;
        }

        private void resolve(NodeData nodeState, List<NodeData> collector, int offset) throws RepositoryException {
            List<Object> cne;
            QPathEntry currentName = this.pattern.getEntries()[offset];
            if (currentName.getAsString().equals("*")) {
                cne = AggregateRuleImpl.this.ism.getChildNodesData(nodeState);
            } else {
                cne = new ArrayList();
                ItemData item = AggregateRuleImpl.this.ism.getItemData(nodeState, currentName);
                if (item != null && item.isNode()) {
                    cne.add((NodeData)item);
                }
            }
            if (this.pattern.getEntries().length - 1 == offset) {
                for (NodeData nodeData : cne) {
                    if (this.nodeTypeName != null && (nodeData == null || !nodeData.getPrimaryTypeName().equals(this.nodeTypeName))) continue;
                    collector.add(nodeData);
                }
            } else {
                ++offset;
                for (NodeData nodeData : cne) {
                    if (nodeData == null) continue;
                    this.resolve(nodeData, collector, offset);
                }
            }
        }
    }
}

