/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.log.ExoLogger;

public class FileBasedNamespaceMappings
implements NamespaceMappings {
    private static Log log = ExoLogger.getLogger(NamespaceMappings.class);
    private final File storage;
    private final LocationFactory nameResolver;
    private Map prefixToURI = new HashMap();
    private Map uriToPrefix = new HashMap();
    private int prefixCount;

    public FileBasedNamespaceMappings(File file) throws IOException {
        this.storage = file;
        this.load();
        this.nameResolver = new LocationFactory(this);
    }

    public String translatePropertyName(InternalQName qName) throws IllegalNameException {
        try {
            return this.nameResolver.createJCRName(qName).getAsString();
        }
        catch (RepositoryException e) {
            throw new IllegalNameException("Internal error.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.storage.exists()) {
            FileInputStream in = new FileInputStream(this.storage);
            try {
                Properties props = new Properties();
                log.debug("loading namespace mappings...");
                props.load(in);
                for (String string : props.keySet()) {
                    String uri = props.getProperty(string);
                    log.debug(string + " -> " + uri);
                    this.prefixToURI.put(string, uri);
                    this.uriToPrefix.put(uri, string);
                }
                this.prefixCount = props.size();
                log.debug("namespace mappings loaded.");
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() throws IOException {
        Properties props = new Properties();
        for (String prefix : this.prefixToURI.keySet()) {
            String uri = (String)this.prefixToURI.get(prefix);
            props.setProperty(prefix, uri);
        }
        OutputStream out = new FileOutputStream(this.storage);
        try {
            out = new BufferedOutputStream(out);
            props.store(out, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public String[] getAllNamespacePrefixes() throws RepositoryException {
        return this.prefixToURI.keySet().toArray(new String[this.prefixToURI.keySet().size()]);
    }

    public String getNamespacePrefixByURI(String uri) throws NamespaceException, RepositoryException {
        String prefix = (String)this.uriToPrefix.get(uri);
        if (prefix == null) {
            while (this.prefixToURI.get(String.valueOf(this.prefixCount)) != null) {
                ++this.prefixCount;
            }
            prefix = String.valueOf(this.prefixCount);
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            log.debug("adding new namespace mapping: " + prefix + " -> " + uri);
            try {
                this.store();
            }
            catch (IOException e) {
                throw new NamespaceException("Could not obtain a prefix for uri: " + uri, e);
            }
        }
        return prefix;
    }

    public String getNamespaceURIByPrefix(String prefix) throws NamespaceException, RepositoryException {
        if (!this.prefixToURI.containsKey(prefix)) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return (String)this.prefixToURI.get(prefix);
    }
}

